/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.util.Objects;

public class GalileoParserUpdateProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        MirA02Section ticketData = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        product.setProductCategory(ProductCategory.AIR);
        String validatingAirlineCode = mirFile.getHeader().getValidatingAirlineCode();
        Airline airline = DictHelper.findAirlineByAnyCode((String)validatingAirlineCode);
        if (airline != null) {
            product.setCarrier((DictionaryReference)airline.toReference());
            product.setCarrierNumber(airline.getAirlineNumber());
        } else {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{ticketData.getTicketNumber(), mirFile.getHeader().getValidatingAirlineCode()}));
        }
        String fareCalculationLie = mirFile.getA09Sections().stream().filter(s -> s.getFareItemId().equals(ticketData.getFareItemNumber())).map(s -> s.getFareCalculationLine()).findFirst().orElse(null);
        String endorsment = mirFile.getA08Sections().stream().filter(s -> s.getFareSectionId().equals(ticketData.getFareItemNumber())).map(s -> s.getFullEndorsement()).filter(Objects::nonNull).findFirst().orElse(null);
        product.setEndorsement(endorsment);
        product.setFareCalculationData(fareCalculationLie);
    }
}

