/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA23Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;

public class GalileoParserUpdateRefundProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigDecimal productFare;
        BigDecimal refundedFare;
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        MirA23Section refundData = (MirA23Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A23SECTION);
        Product refund = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        refund.setIssueDate(refundData.getRefundDate() == null ? MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getMirCreationDate()) : MiscUtil.toDate((LocalDate)refundData.getRefundDate()));
        ArrayList<Integer> refundedCoupons = new ArrayList<Integer>();
        String couponsNumbers = refundData.getCouponsNumbers();
        for (int n = 1; n < 10; ++n) {
            if (!couponsNumbers.contains(n + "")) continue;
            refundedCoupons.add(n);
        }
        if (!couponsNumbers.isEmpty()) {
            Iterator stIter = refund.getSegmentTariffs().iterator();
            while (stIter.hasNext()) {
                SegmentTariff st = (SegmentTariff)stIter.next();
                st.getSegments().removeIf(seg -> !refundedCoupons.contains(seg.getRecordNumber()));
                if (!st.getSegments().isEmpty()) continue;
                stIter.remove();
            }
        }
        boolean needFopRecalculation = false;
        if (refundData.getPenaltyAmount() != null && BigDecimal.ZERO.compareTo(refundData.getPenaltyAmount()) != 0) {
            needFopRecalculation = true;
            refund.setPenalty(refundData.getPenaltyAmount());
        }
        ArrayList<String> returnedTaxes = new ArrayList<String>();
        if (!TextUtil.isBlank((String)refundData.getRefundedTax1())) {
            returnedTaxes.add(refundData.getRefundedTax1());
        }
        if (!TextUtil.isBlank((String)refundData.getRefundedTax2())) {
            returnedTaxes.add(refundData.getRefundedTax2());
        }
        if (!TextUtil.isBlank((String)refundData.getRefundedTax3())) {
            returnedTaxes.add(refundData.getRefundedTax3());
        } else {
            returnedTaxes.addAll(refundData.getIndividualRefundedTaxes());
        }
        ArrayList oldTaxes = new ArrayList(refund.getTaxes());
        refund.getTaxes().clear();
        for (String taxStr : returnedTaxes) {
            BigDecimal taxAmount = new BigDecimal(taxStr.substring(0, taxStr.length() - 2).trim());
            String taxCode = taxStr.substring(taxStr.length() - 2);
            Tax oldTax = oldTaxes.stream().filter(t -> taxCode.equals(t.getCode())).findFirst().orElse(null);
            if (oldTax != null && oldTax.getEquivalentAmount() != null && taxAmount.compareTo(oldTax.getEquivalentAmount()) == 0) {
                refund.getTaxes().add(oldTax);
                continue;
            }
            Tax tax = new Tax();
            tax.setCode(taxCode);
            tax.setEquivalentAmount(taxAmount);
            refund.getTaxes().add(tax);
        }
        BigDecimal refundTaxAmount = AirProductTaxHelper.getEquivalentTaxesAmount((Product)refund.getPreviousProduct());
        if (refundTaxAmount.compareTo(AirProductTaxHelper.getEquivalentTaxesAmount((Product)refund)) != 0) {
            needFopRecalculation = true;
        }
        if (refundData.getTotalRefundedAmount() != null && (refundedFare = refundData.getTotalRefundedAmount().add(MiscUtil.guarded((BigDecimal)refund.getPenalty())).subtract(refundTaxAmount)).compareTo(productFare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)refund))) != 0) {
            refund.getFares().clear();
            AirProductHelper.setEquivalentFare((Product)refund, (BigDecimal)refundedFare);
            needFopRecalculation = true;
        }
        if (needFopRecalculation) {
            AirProductHelper.updateFops((Product)refund);
        }
    }
}

