/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class GalileoParserVoidTicketProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirA02Section ticketData = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        MirFile file = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        if (TextUtil.isBlank((String)ticketData.getTicketNumber())) {
            throw Xeption.forEndUser((String)"\u0432 \u0444\u0430\u0439\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0431\u0438\u043b\u0435\u0442\u0430", (Object[])((Object[])ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION)));
        }
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if (prod.getStatus() == ProductStatus.VOID && this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), ticketData.getTicketNumber())) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0431\u0438\u043b\u0435\u0442 {0} \u0443\u0436\u0435 \u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[]{prod.getSystemNumber()}));
                ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
            if (prod.getStatus() != ProductStatus.SELL || !this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), ticketData.getTicketNumber())) continue;
            prod.setStatus(ProductStatus.VOID);
            prod.setIssueDate(file.getHeader().getPnrLastChangeDate() == null ? MiscUtil.toDate((LocalDateTime)file.getHeader().getMirCreationDate()) : MiscUtil.toDate((LocalDate)file.getHeader().getPnrLastChangeDate()));
            ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
            return;
        }
        throw Xeption.forEndUser((String)"\u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u0438\u043b\u0435\u0442 \u0441 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c", (Object[])new Object[]{ticketData.getTicketNumber()});
    }

    private boolean hasAppropritedSystemNumber(String systemNumber, int conjCount, String ticketNumber) {
        if (TextUtil.isBlank((String)systemNumber)) {
            return false;
        }
        if (ticketNumber.equals(systemNumber)) {
            return true;
        }
        for (int n = 1; n <= conjCount; ++n) {
            if (!FormattedNumberUtil.add((String)systemNumber, (long)1L).equals(systemNumber)) continue;
            return true;
        }
        return false;
    }
}

