/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;
import java.util.Collections;

public class GalileoParsersUpdateContextWithFopDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirA02Section ticketData = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        MirFile file = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        BigDecimal totalAmount = file.getA07Sections().stream().filter(s -> s.getSectionIndicator().equals(ticketData.getFareItemNumber())).map(s -> new BigDecimal(s.getTotalAmountStr())).findFirst().orElse(null);
        if (totalAmount == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u043b\u043d\u043e\u0439 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        if (file.getA11Section() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u043e\u0440\u043c\u0430\u0445 \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        FopItem fopItem = new FopItem();
        fopItem.setPaymentType(MirParserHelper.getPaymentType(file.getA11Section().getPaymentType()));
        fopItem.setAmount(totalAmount);
        ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(fopItem));
    }
}

