/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;

public class GalileoUpdateBspCommissionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        if (AirProductHelper.isBSPTicket((Product)product)) {
            if (mirFile.getHeader().getCommissionAmount() != null && BigDecimal.ZERO.compareTo(mirFile.getHeader().getCommissionAmount()) != 0) {
                product.setBspCommissionValue(SystemHelper.getMoney((BigDecimal)mirFile.getHeader().getCommissionAmount(), (String)(product.getGdsCurrency() == null ? DictHelper.getEquivCurrency() : product.getGdsCurrency())));
            } else if (mirFile.getHeader().getCommissionPercent() != null) {
                product.setBspCommissionRate(Double.valueOf(mirFile.getHeader().getCommissionPercent().doubleValue()));
            }
        }
    }
}

