/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.register;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.model.galileo.GalileoExchangeDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;

public class GalileoCreateRegisteredDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        GalileoExchangeDocument doc = new GalileoExchangeDocument();
        doc.setCreated(MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getCreated()));
        doc.setPNR(mirFile.getHeader().getRecordLocator());
        doc.setOperationDate(MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getCreated()));
        boolean hasExchange = false;
        boolean hasRefund = !mirFile.getA23Sections().isEmpty();
        boolean hasVoid = false;
        for (MirA02Section mirA02Section : mirFile.getA02Sections()) {
            ProductStatus productStatus = MirParserHelper.getProductStatus(mirFile, mirA02Section);
            if (productStatus == ProductStatus.EXCHANGE) {
                hasExchange = true;
            }
            if (productStatus != ProductStatus.VOID) continue;
            hasVoid = true;
        }
        if (hasRefund) {
            doc.setTransactionType(TransactionType.REFUND);
        } else if (hasVoid) {
            doc.setTransactionType(TransactionType.CANCEL);
        } else if (hasExchange) {
            doc.setTransactionType(TransactionType.EXCHANGE);
        } else {
            doc.setTransactionType(TransactionType.SELL);
        }
        doc.setContentType(ContentType.TEXT);
        Map travs = (Map)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.TRAVELLER_DATA_MAP);
        for (MirA02Section item : mirFile.getA02Sections()) {
            Traveller traveller;
            if (!TextUtil.isBlank((String)item.getTicketNumber())) {
                doc.getTicketNumbers().add(item.getTicketNumber());
            }
            if ((traveller = (Traveller)travs.get(item.getPassengerName())) == null) continue;
            doc.getTravellerNames().add(traveller.getName());
        }
        byte[] byArray = (byte[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        doc.setContent(byArray);
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST, Collections.singletonList(doc));
    }
}

