/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.hotelAggregator.ibus.processing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.CustomerInfo;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BuildSalesContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ReservationResult reservationResult = (ReservationResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.HOTELS_RESERVATION_RESULT);
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)this.buildSalesContext(reservationResult));
    }

    private SalesContext buildSalesContext(ReservationResult reservationResult) {
        SalesContext result = new SalesContext();
        Optional<String> email = Optional.ofNullable(reservationResult.getCustomer()).map(CustomerInfo::getEmail);
        if (email.isPresent()) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.emails.name(), (Object)email.get()));
            List persons = EntityStorage.get().search(PersonIndex.class, query).getData();
            if (persons.size() == 1) {
                EntityReference agent = ((PersonIndex)persons.get(0)).getSource();
                EntityReference<Organization> agency = BuildSalesContextProcessor.findEmploymentForPerson((EntityReference<Person>)agent);
                result.setAgent(agent);
                result.setAgency(agency);
                result.setSubagency(agency);
            }
        }
        return result;
    }

    private static EntityReference<Organization> findEmploymentForPerson(EntityReference<Person> person) {
        PersonEmployment employment;
        EntityContainer personCtr = EntityStorage.get().resolve(person);
        List<PersonEmployment> employments = BuildSalesContextProcessor.getValidEmployments((Person)personCtr.getEntity());
        if (employments.size() == 1 && (employment = employments.get(0)).isMainEmployment()) {
            return employment.getOrganization();
        }
        return null;
    }

    private static List<PersonEmployment> getValidEmployments(Person person) {
        Date currentDate = new Date();
        return person.getEmployments().stream().filter(pe -> pe.getOrganization() != null).filter(PersonEmployment::isMainEmployment).filter(pe -> MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)currentDate)).collect(Collectors.toList());
    }
}

