/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.hotelAggregator.ibus.processing;

import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.stream.Collectors;

public class HotelAggregatorBookingFileAlreadyExistsProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) {
        ReservationResult reservationResult = (ReservationResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.HOTELS_RESERVATION_RESULT);
        boolean bookingFileExists = this.searchBookingFileContainer(ctx, reservationResult.getReservationId().getPnr());
        return bookingFileExists ? "YES" : "NO";
    }

    private boolean searchBookingFileContainer(MessageContext ctx, String pnr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        List bookingFiles = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(EntityStorageHelper::nonEmpty).filter(bf -> {
            Reservation reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)pnr);
            if (reservation == null) {
                return false;
            }
            List hotelProducts = reservation.getProducts().stream().filter(HotelProduct.class::isInstance).map(HotelProduct.class::cast).collect(Collectors.toList());
            return hotelProducts.isEmpty() || hotelProducts.stream().anyMatch(p -> p.getTicketType() != TicketType.CORRECTION);
        }).collect(Collectors.toList());
        if (!bookingFiles.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"HotelAggregatorExchangeProcessor_bookingFileAlreadyExists", (Object[])new Object[]{pnr}));
            return true;
        }
        return false;
    }
}

