/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.hotelAggregator.ibus.registration;

import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.LoadReservationsParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.parsers.model.hotelAggregator.HotelAggregatorParserSettings;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.parsers.hotelAggregator.ibus.registration.ExchangeDocumentHotelAggregatorResource;
import com.gridnine.xtrip.server.parsers.hotelAggregator.util.HotelAggregatorSerializationUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeDocumentHotelAggregatorResourceProvider
implements ExchageDocumentResourceProvider<ExchangeDocumentHotelAggregatorResource> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final HotelAggregatorParserSettings settings;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String DB_PROPS_HOTEL_AGGREGATOR_LAST_DATE_UPDATED = "hotel_aggregator.last-date-updated";

    public ExchangeDocumentHotelAggregatorResourceProvider(HotelAggregatorParserSettings settings) {
        this.settings = settings;
    }

    public List<ExchangeDocumentHotelAggregatorResource> getResources() {
        String lastDateUpdated = LogicalStorage.get().getDbPropertiesStorage().getValue(DB_PROPS_HOTEL_AGGREGATOR_LAST_DATE_UPDATED);
        LocalDate today = LocalDate.now();
        ArrayList<ExchangeDocumentHotelAggregatorResource> result = new ArrayList<ExchangeDocumentHotelAggregatorResource>();
        for (EntityReference gdsAccount : this.settings.getGdsAccounts()) {
            LocalDate date = lastDateUpdated != null ? LocalDate.parse(lastDateUpdated, DATE_FORMATTER) : today;
            this.log.info(String.format("getting all orders for gds account %s created from %s", gdsAccount.getCaption(), date));
            do {
                HashMap<String, Object> data = new HashMap<String, Object>();
                this.loadReservations(date, date, (EntityReference<HotelsAggregatorGdsAccount>)gdsAccount, data);
                List reservationResults = (List)data.get(IBusHotelsContextKeys.HOTELS_LOAD_RESERVATIONS_RESULT.name());
                result.addAll(this.processOrders(reservationResults));
            } while (MiscUtil.compare((Comparable)(date = date.plusDays(1L)), (Comparable)today) <= 0);
        }
        this.log.info("got " + result.size() + " orders");
        LogicalStorage.get().getDbPropertiesStorage().putValue(DB_PROPS_HOTEL_AGGREGATOR_LAST_DATE_UPDATED, DATE_FORMATTER.format(today));
        return result;
    }

    private void loadReservations(LocalDate startDate, LocalDate endDate, EntityReference<HotelsAggregatorGdsAccount> gdsAccount, Map<String, Object> data) {
        LoadReservationsParameters params = new LoadReservationsParameters();
        params.setStartDate(startDate);
        params.setEndDate(endDate);
        params.setGdsAccount(gdsAccount);
        data.put(IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS.name(), params);
        IntegrationBusFacade.get().processRouteSync("hotels2:load-reservations:load-reservations-route", data);
    }

    private List<ExchangeDocumentHotelAggregatorResource> processOrders(Collection<ReservationResult> orders) {
        if (orders == null || orders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExchangeDocumentHotelAggregatorResource> result = new ArrayList<ExchangeDocumentHotelAggregatorResource>();
        for (ReservationResult reservationResult : orders) {
            result.add(new ExchangeDocumentHotelAggregatorResource("Hotel aggregator order", reservationResult));
        }
        return result;
    }

    public void moveTo(ExchangeDocumentHotelAggregatorResource resource, String targetFolder) {
    }

    public byte[] getContent(ExchangeDocumentHotelAggregatorResource resource) {
        return HotelAggregatorSerializationUtil.serialize(resource.getReservationResult());
    }
}

