/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.hotelAggregator.ibus.registration;

import com.gridnine.hotels.web.ws.Guest;
import com.gridnine.hotels.web.ws.Provider;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationItemStatusInfo;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.model.hotelAggregator.HotelAggregatorExchangeDocument;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.hotelAggregator.util.HotelAggregatorSerializationUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class HotelAggregatorCreateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ExchangeFile file = (ExchangeFile)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        byte[] content = file.getContent();
        ReservationResult reservationResult = HotelAggregatorSerializationUtil.deserialize(content);
        HotelAggregatorExchangeDocument exchangeDocument = new HotelAggregatorExchangeDocument();
        exchangeDocument.setContentType(ContentType.XML);
        exchangeDocument.setContent(content);
        exchangeDocument.setDescription("Hotel Aggregator order info");
        exchangeDocument.setTitle("Hotel Aggregator order");
        exchangeDocument.setLocation(file.getLocation());
        exchangeDocument.setCreated(file.getCreated());
        exchangeDocument.setType(file.getType());
        exchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
        exchangeDocument.setProvider(HotelsBaseHelper.convertProviderFromGds((Provider)reservationResult.getProvider()));
        exchangeDocument.setGdsAccount(this.findGdsAccount(reservationResult));
        exchangeDocument.setReservationNumber(reservationResult.getReservationId().getReservationNumber());
        exchangeDocument.setIssueDate(HotelsBaseHelper.toDate((XMLGregorianCalendar)reservationResult.getCreatedAt().getDate()));
        for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
            exchangeDocument.getProducts().add(item.getRawId());
            ProductStatus productStatus = HotelsBaseHelper.convertToProductStatus((ReservationItemStatusInfo)item.getItemStatusInfo());
            switch (productStatus) {
                case SELL: 
                case REQUEST: {
                    exchangeDocument.getTransactions().add(TransactionType.SELL);
                    break;
                }
                case REFUND: {
                    exchangeDocument.getTransactions().add(TransactionType.REFUND);
                    break;
                }
                case REJECT: {
                    exchangeDocument.getTransactions().add(TransactionType.CANCEL);
                }
            }
            if (item.getGuests() == null) continue;
            exchangeDocument.getTravellers().addAll(item.getGuests().getGuest().stream().map(Guest::getFullName).filter(TextUtil::nonBlank).collect(Collectors.toList()));
        }
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT, (Object)exchangeDocument);
    }

    private EntityReference<BaseGdsAccount> findGdsAccount(ReservationResult reservationResult) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.HOTEL_AGGREGATOR));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.hotelProvider.name(), (Object)reservationResult.getProvider()));
        List gdsAccountIndices = EntityStorage.get().search(GdsAccountIndex.class, query).getData();
        return gdsAccountIndices.stream().map(GdsAccountIndex::getSource).filter(gdsAccountRef -> {
            EntityContainer gdsAccountCtr = EntityStorage.get().resolve(gdsAccountRef);
            if (gdsAccountCtr != null) {
                return MiscUtil.equals((Object)reservationResult.getPcc(), (Object)((HotelsAggregatorGdsAccount)gdsAccountCtr.getEntity()).getPcc(), (boolean)false);
            }
            return false;
        }).findFirst().orElse(null);
    }
}

