/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.oneliya.model.OneliyaExchangeDocument;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OneliyaServlet
extends HttpServlet {
    private static final long serialVersionUID = -2386922417132102991L;
    public static final String REQUEST_BODY_ENCODING = "utf8";
    public static final String RESPONSE_SUCCEFULL_CODE = "OK";
    public static final String RESPONSE_UNAUTHORIZED = "Unauthorized";
    public static final String STORE_ENCODING = "utf8";
    protected final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dump(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean authorize = false;
            try {
                String authHeader = request.getHeader("Authorization");
                String[] userCredentials = new String(Base64.decode((String)authHeader.substring(6))).split(":");
                LogicalStorage.get().authorize(userCredentials[0], userCredentials[1].toCharArray());
                authorize = true;
            }
            catch (Exception e) {
                this.log.error((Object)"unable to authorize on onelya online request", (Throwable)e);
                response.setStatus(401);
            }
            if (authorize) {
                this.processRequest(request);
            }
        }
        finally {
            this.processResponse(response);
            LogicalStorage.reset();
        }
    }

    private void processRequest(HttpServletRequest request) {
        try {
            this.log.debug((Object)"onelya online request process start");
            this.log.debug((Object)("onelya online request requestHeader:\n\n" + this.createHeaderString(request)));
            StringBuilder body = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                body.append(line);
                body.append("\n");
            }
            this.log.debug((Object)("onelya online request body:\n\n" + body));
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date date = new Date();
            String name = String.format("onelya_online_%s.xml", format.format(date));
            String content = body.toString();
            ExchangeFile exchangeFile = new ExchangeFile();
            exchangeFile.setType(OneliyaExchangeDocument.class.getName());
            exchangeFile.setCreated(new Date());
            exchangeFile.setLocation(name);
            exchangeFile.setContent(content.getBytes("utf8"));
            try {
                this.log.debug((Object)"onelya online exchange file register process start");
                ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get(OneliyaExchangeDocument.class.getName());
                processor.registerExchangeFile(exchangeFile);
                this.log.debug((Object)"onelya online exchange file register process end");
            }
            catch (Exception e) {
                this.log.error((Object)"unable to register onelya online exchange file", (Throwable)e);
            }
            this.log.debug((Object)"onelya online request process end");
        }
        catch (IOException ioe) {
            this.log.error((Object)"unable to process onelya online request", (Throwable)ioe);
        }
    }

    private void processResponse(HttpServletResponse response) throws IOException {
        this.log.debug((Object)"onelya online response process start");
        PrintWriter writer = response.getWriter();
        if (response.getStatus() == 401) {
            writer.write(RESPONSE_UNAUTHORIZED);
        } else {
            writer.write(RESPONSE_SUCCEFULL_CODE);
        }
        writer.flush();
        this.log.debug((Object)"onelya online response process end");
    }

    private String createHeaderString(HttpServletRequest request) throws IOException {
        StringBuilder headerString = new StringBuilder();
        headerString.append("method = " + request.getMethod());
        headerString.append("\n");
        Enumeration headerNamesEnumerator = request.getHeaderNames();
        while (headerNamesEnumerator.hasMoreElements()) {
            String headerName = (String)headerNamesEnumerator.nextElement();
            Enumeration headersEnumerator = request.getHeaders(headerName);
            while (headersEnumerator.hasMoreElements()) {
                String headerValue = (String)headersEnumerator.nextElement();
                headerString.append(headerName).append(" = ").append(headerValue).append("\n");
            }
        }
        headerString.append("\n");
        return URLDecoder.decode(headerString.toString(), "utf-8");
    }

    private void dump(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        try {
            String dump = this.createDump(request);
            this.log.debug((Object)String.format("request ok:\n%s", dump));
            writer.write("<h1>OK</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", dump.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        catch (IOException e) {
            this.log.debug((Object)String.format("request error:\n%s", e.getMessage()));
            writer.write("<h1>ERROR</h1>");
            writer.write("<hr>");
            writer.write(String.format("<pre>%s</pre>", URLDecoder.decode(e.getMessage(), "utf-8").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
        }
        writer.flush();
    }

    private String createDump(HttpServletRequest request) throws IOException {
        StringBuilder dump = new StringBuilder();
        dump.append("HEADER");
        dump.append("\n\n");
        Enumeration headerNamesEnumerator = request.getHeaderNames();
        dump.append("method -> " + request.getMethod());
        dump.append("\n");
        while (headerNamesEnumerator.hasMoreElements()) {
            String headerName = (String)headerNamesEnumerator.nextElement();
            Enumeration headersEnumerator = request.getHeaders(headerName);
            while (headersEnumerator.hasMoreElements()) {
                String header = (String)headersEnumerator.nextElement();
                dump.append(headerName + " -> " + header);
                dump.append("\n");
            }
        }
        dump.append("\n");
        dump.append("BODY");
        dump.append("\n\n");
        StringBuilder body = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            body.append(line);
            body.append("\n");
        }
        String[] parameters = body.toString().split("&");
        body = new StringBuilder();
        for (String parameter : parameters) {
            String[] tokens = parameter.split("=");
            if (tokens.length > 0) {
                body.append(tokens[0]);
            }
            if (tokens.length > 1) {
                body.append(" -> " + tokens[1]);
            }
            body.append("\n");
        }
        dump.append((CharSequence)body);
        return URLDecoder.decode(dump.toString(), "utf8");
    }
}

