/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.parsers.oneliya.model.OneliyaParserSettings;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import java.util.List;
import java.util.Objects;

public class GetOneliyaParseSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaParserSettings settings = this.getOneliyaParserSettings();
        Objects.requireNonNull(settings, "Oneliya parser settings not found");
        List blankOwnerSettings = settings.getBlankOwnerSettings();
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.BLANK_OWNER_SETTINGS, (Object)blankOwnerSettings);
    }

    private OneliyaParserSettings getOneliyaParserSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(OneliyaParserSettings.class.getName());
        EntityContainer settings = EntityStorage.get().load(OneliyaParserSettings.class, settingsUid);
        return EntityStorageHelper.nonEmpty((EntityContainer)settings) ? (OneliyaParserSettings)settings.getEntity() : null;
    }
}

