/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.oneliya.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaFareDescription;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemRoutePart;
import java.util.Date;

public class OneliyaBuildSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        SegmentTariff st = new SegmentTariff();
        int segNo = 0;
        for (OneliyaOrderItemRoutePart routePart : orderItem.getOrderItemRouteParts()) {
            String destinationCode;
            String originCode;
            String serviceClass;
            String marketingAirlineCode;
            String airplaneCode;
            LuggageInfo luggageInfo;
            Segment segment = new Segment();
            ++segNo;
            segment.setFlightNo(routePart.getFlightNumber());
            segment.setFareBasis(routePart.getFareCode());
            segment.setClassOfSvcCode(routePart.getServSubclass());
            segment.setDepartTerminal(routePart.getOriginTerminal());
            segment.setArriveTerminal(routePart.getDestinationTerminal());
            segment.setFlightDuration(Integer.valueOf(MiscUtil.getMinutes((Date)routePart.getFlightDuration())));
            segment.setAirlineLocator(routePart.getAirlinePnr());
            segment.setStartDate(routePart.getDeparture());
            segment.setEndDate(routePart.getArrival());
            OneliyaFareDescription.BaggageInfo baggageInfo = routePart.getFareDescription().getBaggageInfo();
            if (baggageInfo != null && (luggageInfo = AirProductHelper.parseLuggageInfo((String)baggageInfo.getDescription())) != null) {
                segment.setLuggageInfo(luggageInfo);
            }
            if (TextUtil.nonBlank((String)(airplaneCode = routePart.getAirplane()))) {
                Aircraft aircraft = DictHelper.findAircraftByAnyCode((String)airplaneCode);
                if (aircraft == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_AircraftNotFound), (Object[])new Object[]{airplaneCode}));
                } else {
                    segment.setBoard((DictionaryReference)aircraft.toReference());
                }
            }
            if (TextUtil.nonBlank((String)(marketingAirlineCode = routePart.getMarketingAirlineCode()))) {
                Airline marketingCarrier = DictHelper.findAirlineByAnyCode((String)marketingAirlineCode);
                if (marketingCarrier == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_MarketingCarrierNotFound), (Object[])new Object[]{marketingAirlineCode}));
                } else {
                    segment.setAirline((DictionaryReference)marketingCarrier.toReference());
                }
            }
            if (TextUtil.nonBlank((String)(serviceClass = routePart.getServiceClass()))) {
                ClassOfService classOfService = OneliyaModelHelper.getServiceClass(serviceClass);
                if (classOfService == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_ClassOfServiceNotFound), (Object[])new Object[]{marketingAirlineCode}));
                } else {
                    segment.setServiceClass(classOfService);
                }
            }
            if (TextUtil.nonBlank((String)(originCode = routePart.getOriginCode()))) {
                segment.setDepartCityCode(originCode);
                GeoLocation originAirport = DictHelper.findAirportByCodeVariant((String)originCode);
                if (originAirport == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_AirportNotFound), (Object[])new Object[]{originCode}));
                } else {
                    segment.setDepartureLocation((DictionaryReference)originAirport.toReference());
                }
            }
            if (TextUtil.nonBlank((String)(destinationCode = routePart.getDestinationCode()))) {
                segment.setArriveCityCode(destinationCode);
                GeoLocation destinationAirport = DictHelper.findAirportByCodeVariant((String)destinationCode);
                if (destinationAirport == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_AirportNotFound), (Object[])new Object[]{destinationCode}));
                } else {
                    segment.setArriveLocation((DictionaryReference)destinationAirport.toReference());
                }
            }
            segment.setRecordNumber(segNo);
            segment.setGdsId(routePart.getOrderItemRoutePartId());
            st.getSegments().add(segment);
        }
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.SEGMENT_TARIFF, (Object)st);
    }
}

