/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.math.BigDecimal;

public class OneliyaCreateFaresAndTaxesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        product.getFares().clear();
        OneliyaOrderItemBlank.FiscalData.FiscalLine fareFiscalLine = orderItemBlank.getFiscalData().stream().flatMap(it -> it.getFiscalLines().stream()).filter(it -> (product.getMcoCategory() == MCOCategory.STICKER ? "Penalty" : "Fare").equals(it.getLineType())).findFirst().orElse(null);
        VatDetalization vatDetalization = new VatDetalization();
        if (fareFiscalLine != null) {
            AirProductHelper.setBaseFare((Product)product, (Money)MoneyHelper.buildMoney((Double)fareFiscalLine.getAmount(), (String)"RUB"));
            product.setGdsCurrency("RUB");
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(fareFiscalLine.getAmount()));
            if (fareFiscalLine.getVat() != null) {
                VatComponent fareVat = new VatComponent();
                fareVat.setBasis(BigDecimal.valueOf(fareFiscalLine.getAmount()));
                fareVat.setSum(BigDecimal.valueOf(fareFiscalLine.getVat()));
                fareVat.setRate(OneliyaModelHelper.getVatRate(fareFiscalLine.getVatType()));
                fareVat.getBasisTypes().add(VatBasisType.FARE);
                vatDetalization.getComponents().add(fareVat);
            }
        }
        product.getTaxes().clear();
        orderItemBlank.getFiscalData().stream().flatMap(it -> it.getFiscalLines().stream()).filter(it -> "Tax".equals(it.getLineType()) || "ProviderTax".equals(it.getLineType())).forEach(fiscalLine -> {
            Tax productTax = new Tax();
            product.getTaxes().add(productTax);
            productTax.setCode(fiscalLine.getCode());
            productTax.setAmount(MoneyHelper.buildMoney((Double)fiscalLine.getAmount(), (String)"RUB"));
            productTax.setEquivalentAmount(BigDecimal.valueOf(fiscalLine.getAmount()));
            VatComponent taxVat = new VatComponent();
            taxVat.setBasis(fiscalLine.getAmount() != null ? BigDecimal.valueOf(fiscalLine.getAmount()) : null);
            taxVat.setSum(fiscalLine.getVat() != null ? BigDecimal.valueOf(fiscalLine.getVat()) : null);
            taxVat.setRate(OneliyaModelHelper.getVatRate(fiscalLine.getVatType()));
            taxVat.getBasisTypes().add(VatBasisType.TAXES);
            taxVat.getTaxesUids().add(productTax.getUid());
            vatDetalization.getComponents().add(taxVat);
        });
        if (!vatDetalization.getComponents().isEmpty()) {
            vatDetalization.setDetalized(true);
            product.setVendorVatDetalization(vatDetalization);
        }
    }
}

