/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.List;

public class OneliyaCreateOrGetProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        List productsToRemove = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_TO_REMOVE_LIST);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        ProductStatus status = OneliyaModelHelper.getProductStatus(orderItem);
        String blankNumber = orderItemBlank.getBlankNumber();
        Product product = null;
        if (TextUtil.nonBlank((String)blankNumber) && blankNumber.length() > 3) {
            String ticketNumber = blankNumber.substring(3);
            product = products.stream().filter(prod -> prod.getSystemNumber().equals(ticketNumber)).filter(prod -> prod.getStatus().equals((Object)status)).findFirst().orElse(null);
        }
        if (product == null) {
            product = new Product();
            product.setStatus(ProductStatus.SELL);
            products.add(product);
        } else if (product.getTicketType() == TicketType.FAKE) {
            Product newProduct = new Product();
            newProduct.setStatus(ProductStatus.SELL);
            if (product.getNextProduct() != null) {
                newProduct.setNextProduct(product.getNextProduct());
                product.getNextProduct().setPreviousProduct(newProduct);
            }
            if (product.getPreviousProduct() != null) {
                newProduct.setPreviousProduct(product.getPreviousProduct());
                product.getPreviousProduct().setNextProduct(newProduct);
            }
            productsToRemove.add(product);
            products.remove(product);
            products.add(newProduct);
            ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)newProduct);
            return;
        }
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)product);
    }
}

