/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OneliyaCreatePenalty
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        List penaltyList = orderItemBlank.getFiscalData().stream().flatMap(it -> it.getFiscalLines().stream()).filter(it -> "Penalty".equals(it.getLineType())).collect(Collectors.toList());
        if (!penaltyList.isEmpty()) {
            product.setPenalty(penaltyList.stream().map(OneliyaOrderItemBlank.FiscalData.FiscalLine::getAmount).filter(Objects::nonNull).map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
    }
}

