/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OneliyaCreatePenaltyAndExchangeFopItems
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        VatComponent currentVat;
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        List penaltyList = orderItemBlank.getFiscalData().stream().flatMap(it -> it.getFiscalLines().stream()).filter(it -> "Penalty".equals(it.getLineType())).collect(Collectors.toList());
        if (!penaltyList.isEmpty()) {
            BigDecimal penalty = penaltyList.stream().map(OneliyaOrderItemBlank.FiscalData.FiscalLine::getAmount).filter(Objects::nonNull).map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
            product.setPenalty(penalty);
        }
        Product exchange = product.getPreviousProduct();
        List exchangeVendorFops = AirProductHelper.getVendorFops((Product)exchange);
        List exchangeFopsData = exchangeVendorFops.stream().map(it -> {
            FopItem item = new FopItem();
            item.setPaymentType(it.getType());
            item.setAmount(it.getAmount().getValue());
            return item;
        }).collect(Collectors.toList());
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, exchangeFopsData);
        FopItem fopItem = new FopItem();
        fopItem.setPaymentType(OneliyaModelHelper.getPaymentType(orderItem.getProviderPaymentForm()));
        fopItem.setAmount(AirProductHelper.getTotalEquivalentFare((Product)product));
        ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(fopItem));
        product.setAddCollectBase((BigDecimal)Optional.ofNullable(AirProductHelper.getBaseFare((Product)product)).map(Money::getValue).orElse(null));
        product.setAddCollectEquivalent(AirProductHelper.getEquivalentFare((Product)product));
        Money exchangeBaseFare = AirProductHelper.getBaseFare((Product)exchange);
        Money productBaseFare = AirProductHelper.getBaseFare((Product)product);
        if (exchangeBaseFare != null) {
            if (productBaseFare != null) {
                AirProductHelper.setBaseFare((Product)product, (Money)MoneyHelper.sum((Money[])new Money[]{exchangeBaseFare, productBaseFare}));
            } else {
                AirProductHelper.setBaseFare((Product)product, (Money)exchangeBaseFare);
            }
        }
        if (AirProductHelper.getEquivalentFare((Product)exchange) != null) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)exchange), AirProductHelper.getEquivalentFare((Product)product)}));
        }
        product.getTaxes().addAll(exchange.getTaxes());
        if (product.getPreviousProduct() == null || product.getPreviousProduct().getVendorVatDetalization() == null) {
            return;
        }
        VatComponent previousVat = product.getPreviousProduct().getVendorVatDetalization().getComponents().stream().filter(vc -> vc.getBasisTypes().contains(VatBasisType.FARE)).findFirst().orElse(null);
        if (previousVat == null) {
            return;
        }
        if (product.getVendorVatDetalization() == null) {
            product.setVendorVatDetalization(new VatDetalization());
        }
        if ((currentVat = (VatComponent)product.getVendorVatDetalization().getComponents().stream().filter(vc -> vc.getBasisTypes().contains(VatBasisType.FARE)).findFirst().orElse(null)) == null) {
            currentVat = new VatComponent();
            currentVat.setRate(previousVat.getRate());
            if (currentVat.getRate() != null) {
                currentVat.setSum(AirProductHelper.getEquivalentFare((Product)product).multiply(BigDecimal.valueOf(currentVat.getRate())).divide(BigDecimal.valueOf(100L), (int)GeneralProductHelper.getDecimalPlaces((String)(productBaseFare != null ? productBaseFare.getCurrency() : null), (Integer)2), RoundingMode.HALF_UP));
            }
        } else {
            currentVat.setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{previousVat.getSum(), currentVat.getSum()}));
        }
        currentVat.setBasis(AirProductHelper.getEquivalentFare((Product)product));
    }
}

