/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.oneliya.l10n.Messages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util.OneliyaParserHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemCustomers;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OneliyaCreateSellMcoProcessor
extends BaseProcessor {
    private MCOCategory mcoCategory = null;

    public void configure(Map<String, String> parameters) {
        switch (parameters.get("emd_type")) {
            case "Animal": {
                this.mcoCategory = MCOCategory.ANIMALS;
                break;
            }
            case "Baggage": {
                this.mcoCategory = MCOCategory.EXCESS_LUGGAGE;
                break;
            }
            case "Meal": {
                this.mcoCategory = MCOCategory.SPECIAL_FOOD;
                break;
            }
            case "PlaceSelection": {
                this.mcoCategory = MCOCategory.SEAT_RESERVATION;
                break;
            }
            case "Revalidation": {
                this.mcoCategory = MCOCategory.STICKER;
            }
        }
    }

    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        EntityReference subagency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        EntityReference agency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENCY);
        EntityReference supplier = (EntityReference)ctx.getObject((Enum)IbusOneliyaParserContextKeys.SUPPLIER);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        EntityReference salesPoint = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        String pcc = (String)ctx.getObject((Enum)IBusProfileContextKeys.PCC);
        String validatorCode = (String)ctx.getObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_CODE);
        NestedEntityReference validatorRef = (NestedEntityReference)ctx.getObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_REF);
        Product airTicketSell = (Product)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.SELL_PRODUCT);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.TRAVELLERS_MAP);
        Product mcoSell = new Product();
        products.add(mcoSell);
        mcoSell.getRelatedProducts().add(airTicketSell);
        mcoSell.setProductCategory(ProductCategory.MCO);
        mcoSell.setGdsId(String.valueOf(orderItemBlank.getOrderItemBlankId()));
        mcoSell.setMcoCategory(this.mcoCategory);
        if (this.mcoCategory == MCOCategory.STICKER) {
            mcoSell.getSegmentTariffs().addAll(airTicketSell.getSegmentTariffs());
        } else {
            airTicketSell.getSegmentTariffs().stream().filter(st -> st.getSegments().stream().anyMatch(seg -> orderItem.getMainOrderItemRoutePartIds().stream().map(String::valueOf).anyMatch(id -> TextUtil.equals((String)seg.getGdsId(), (String)id, (boolean)false)))).forEach(mcoSell.getSegmentTariffs()::add);
        }
        mcoSell.setTicketType(TicketType.OWN);
        mcoSell.setTariffType(TariffType.REGULAR);
        mcoSell.setStatus(ProductStatus.SELL);
        mcoSell.setIssueDate(orderItem.getConfirmDateTime());
        mcoSell.setEndorsement(orderItemBlank.getEndorsements() != null ? String.join((CharSequence)" ", orderItemBlank.getEndorsements()) : null);
        AirProductHelper.setAgency((Product)mcoSell, (EntityReference)agency);
        AirProductHelper.setSubagency((Product)mcoSell, (EntityReference)subagency);
        mcoSell.setSalesPoint(salesPoint);
        mcoSell.setPcc(pcc);
        mcoSell.setValidatorCode(validatorCode);
        mcoSell.setValidatorRef(validatorRef);
        mcoSell.setCashier(agent);
        OneliyaParserHelper.updateFromServiceProvider(orderItem, mcoSell);
        String ticketNumber = orderItemBlank.getBlankNumber();
        if (TextUtil.nonBlank((String)ticketNumber) && ticketNumber.length() > 3) {
            Airline blankOwnerAirline;
            String validatingCarrierNumber = ticketNumber.substring(0, 3);
            String productNumber = ticketNumber.substring(3);
            mcoSell.setCarrierNumber(validatingCarrierNumber);
            mcoSell.setSystemNumber(productNumber);
            Airline validatingCarrier = (Airline)CollectionUtil.head((Iterable)DictHelper.getAirlinesByNumber((String)validatingCarrierNumber, (Date)orderItem.getCreateDateTime()));
            if (validatingCarrier != null) {
                mcoSell.setCarrier((DictionaryReference)validatingCarrier.toReference());
            }
            if ((blankOwnerAirline = DictHelper.isBspTicket((String)productNumber) ? DictHelper.findAirlineByAnyCode((String)"BSP") : (DictHelper.isTchTicket((String)productNumber) ? DictHelper.findAirlineByAnyCode((String)"\u04281") : validatingCarrier)) != null) {
                mcoSell.setBlankOwnerNumber(blankOwnerAirline.getAirlineNumber());
                EntityReference blankOwner = (EntityReference)CollectionUtil.head((Iterable)ProfileDao.getBlankOwnerReferencesByAirline((DictionaryReference)blankOwnerAirline.toReference()));
                if (blankOwner != null) {
                    mcoSell.setBlankOwnerRef(blankOwner);
                    BlankType blankType = BookingHelper.getBlankType((String)productNumber, (EntityReference)blankOwner, (ProductCategory)mcoSell.getProductCategory(), (boolean)mcoSell.isEticket());
                    if (blankType != null) {
                        mcoSell.setBlankType((DictionaryReference)blankType.toReference());
                    }
                }
            }
            AirProductHelper.setSupplier((Product)mcoSell, (EntityReference)supplier);
            if (airTicketSell.getTraveller() != null) {
                mcoSell.setTraveller(airTicketSell.getTraveller());
                mcoSell.setPassengerType(airTicketSell.getPassengerType());
            } else {
                List orderCustomerIds = orderItem.getOrderItemCustomers().stream().filter(customer -> customer.getOrderItemBlankIds() == null || customer.getOrderItemBlankIds().contains(orderItemBlank.getOrderItemBlankId())).map(OneliyaOrderItemCustomers::getOrderCustomerId).collect(Collectors.toList());
                if (orderCustomerIds.size() > 1) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_tooManyTravellers), (Object[])new Object[]{orderItemBlank.getBlankNumber()}));
                } else if (orderCustomerIds.size() == 1) {
                    Traveller traveller = (Traveller)travellers.get(orderCustomerIds.get(0));
                    mcoSell.setTraveller(traveller);
                    if (!((BookingFile)bookingFile.getEntity()).getTravellers().contains(traveller)) {
                        ((BookingFile)bookingFile.getEntity()).getTravellers().add(traveller);
                    }
                }
            }
            if (this.mcoCategory == MCOCategory.STICKER) {
                mcoSell.setSystemNumber(null);
                mcoSell.setCarrierNumber(null);
                Pattern pattern = Pattern.compile("EMD.*(\\d{3})(\\d{10})");
                orderItemBlank.getEndorsements().forEach(e -> {
                    Matcher matcher = pattern.matcher((CharSequence)e);
                    if (matcher.find()) {
                        mcoSell.setCarrierNumber(matcher.group(1));
                        mcoSell.setSystemNumber(matcher.group(2));
                    }
                });
            }
            ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)mcoSell);
        }
    }
}

