/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class OneliyaFindBookingForVoidingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation;
        EntityContainer bookingFileContainer;
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        List<String> ticketsToVoidNumbers = orderItem.getOrderItemBlanks().stream().map(OneliyaOrderItemBlank::getBlankNumber).filter(blankNumber -> blankNumber.length() > 3).map(blankNumber -> blankNumber.substring(3)).collect(Collectors.toList());
        SearchQuery query = new SearchQuery();
        ticketsToVoidNumbers.forEach(number -> query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.ticketNumbers.name(), (Object)number)));
        SearchResult searchResult = EntityStorage.get().search(BookingFileIndex.class, query);
        if (!searchResult.getData().isEmpty()) {
            BookingFileIndex bfIndex = (BookingFileIndex)searchResult.getData().get(0);
            EntityReference bfRef = bfIndex.getSource();
            bookingFileContainer = EntityStorage.get().resolve(bfRef);
            reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bookingFileContainer.getEntity()), res -> new HashSet(res.getProducts().stream().flatMap(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getProductNumbers(baseProduct).stream()).collect(Collectors.toList())).containsAll(ticketsToVoidNumbers));
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)orderItem.getReservationNumber(), (GdsName)GdsName.ONELIYA)) {
                BookingFile bookingFile = reservation.getBookingFile();
                reservation.setBookingFile(null);
                Reservation splitReservation = (Reservation)XCloneHelper.clone((XCloneable)reservation, (boolean)false);
                splitReservation.setUid(UUID.randomUUID().toString());
                reservation.setBookingFile(bookingFile);
                BookingHelper.addReservation((BookingFile)bookingFile, (Reservation)splitReservation);
                reservation.getProducts().removeIf(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getProductNumbers(baseProduct).stream().anyMatch(ticketsToVoidNumbers::contains));
                splitReservation.getProducts().removeIf(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getProductNumbers(baseProduct).stream().noneMatch(ticketsToVoidNumbers::contains));
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)splitReservation, (GdsName)GdsName.ONELIYA, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)orderItem.getReservationNumber());
                reservation = splitReservation;
            }
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
        } else {
            bookingFileContainer = new EntityContainer(BookingFile.class);
            reservation = new Reservation();
            BookingHelper.addReservation((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (Reservation)reservation);
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)bookingFileContainer);
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)reservation);
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.VOID_TICKET_NUMBERS, ticketsToVoidNumbers);
    }
}

