/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import com.gridnine.xtrip.server.parsers2.common.Parsers2GeneralHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class OneliyaFindDefaultBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        List productList = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        String pnr = orderItem.getReservationNumber();
        if (TextUtil.isBlank((String)pnr)) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 PNR", (Object[])new Object[0]);
        }
        Date creationDate = orderItem.getConfirmDateTime();
        if (creationDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        if (Parsers2GeneralHelper.findBookingByPnr((String)pnr, (Date)creationDate, (GdsName)GdsName.ONELIYA, (boolean)false, (MessageContext)ctx)) {
            EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
            for (Reservation reservation : ((BookingFile)bookingFile.getEntity()).getReservations()) {
                for (BaseProduct product : reservation.getProducts()) {
                    if (!(product instanceof Product)) continue;
                    productList.add((Product)product);
                }
            }
            return;
        }
        for (OneliyaOrderItemBlank blank : orderItem.getOrderItemBlanks()) {
            if ((blank.getPreviousBlankNumber() == null || !this.findByRelatedNumber(ctx, creationDate, blank.getPreviousBlankNumber().substring(3))) && (blank.getBlankNumber() == null || !this.findByRelatedNumber(ctx, creationDate, blank.getBlankNumber().substring(3)))) continue;
            return;
        }
        EntityContainer ctr = new EntityContainer(BookingFile.class);
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
    }

    private boolean findByRelatedNumber(MessageContext ctx, Date creationDate, String relatedTicketNumber) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(creationDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocators.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocator.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)relatedTicketNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)GdsName.ONELIYA));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, GdsName.ONELIYA});
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.productNumber.name(), (Object)relatedTicketNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ArchivedProductIndex.Property.issueDate.name(), (Object)lowerBound));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (ArchivedProductIndex item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (archivedBookings.isEmpty()) {
                return false;
            }
            HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
            for (EntityReference item : archivedBookings) {
                EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                List<Product> products = this.getAllProductsFromMatchingReservations((BookingFile)bookingContainer.getEntity(), relatedTicketNumber, lowerBound);
                if (products.isEmpty()) continue;
                toUnarchive.add(item);
            }
            if (toUnarchive.isEmpty()) {
                return false;
            }
            if (toUnarchive.size() > 1) {
                throw Xeption.forEndUser((String)"\u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1} \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, GdsName.ONELIYA});
            }
            ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        List productList = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        productList.addAll(this.getAllProductsFromMatchingReservations((BookingFile)ctr.getEntity(), relatedTicketNumber, lowerBound));
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
        return true;
    }

    private List<Product> getAllProductsFromMatchingReservations(BookingFile entity, String relatedTicketNumber, Date lowerBound) {
        ArrayList<Product> products = new ArrayList<Product>();
        for (Reservation reservation : entity.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsGds((Reservation)reservation, (GdsName)GdsName.ONELIYA)) continue;
            for (BaseProduct baseProduct : reservation.getProducts()) {
                Product product;
                if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getStatus() != ProductStatus.SELL || !relatedTicketNumber.equals(product.getSystemNumber())) continue;
                if (product.getIssueDate() != null) {
                    if (!product.getIssueDate().after(lowerBound)) continue;
                }
                products.addAll(reservation.getProducts().stream().filter(Product.class::isInstance).map(p -> (Product)p).collect(Collectors.toList()));
            }
        }
        return products;
    }
}

