/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.oneliya.model.OneliyaParserBlankOwnerSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class OneliyaFindSalesChainProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        ArrayList<Message> messages = new ArrayList<Message>();
        Date createDate = orderItem.getCreateDateTime();
        Airline airline = DictHelper.getAirlinesByAnyCode((String)orderItem.getBlankOwnerCode(), (Date)createDate).stream().findFirst().orElse(null);
        if (airline == null) {
            messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_airlineNotFound, (String)L10nResourcesManager.getStr((String)Messages.ParsersHelper_airlineWithCodeNotFound, (Object[])new Object[]{orderItem.getBlankOwnerCode()}), (Object[])new Object[0]));
        } else {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), (Object)airline.toReference()));
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
            List blankOwnerIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (blankOwnerIndexes.size() == 0) {
                messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_blankOwnerDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ParsersHelper_blankOwnerWithCodeNotFound, (Object[])new Object[]{orderItem.getBlankOwnerCode()}), (Object[])new Object[0]));
            } else if (blankOwnerIndexes.size() > 1) {
                messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_blankOwnerDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.ParsersHelper_blankOwnerWithCodeMultipleFound, (Object[])new Object[]{orderItem.getBlankOwnerCode()}), (Object[])new Object[0]));
            }
            if (blankOwnerIndexes.size() > 0) {
                EntityReference blankOwner = ((OrganizationIndex)blankOwnerIndexes.get(0)).getSource();
                List blankOwnerSettings = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.BLANK_OWNER_SETTINGS);
                OneliyaParserBlankOwnerSettings settings = blankOwnerSettings.stream().filter(s -> MiscUtil.equals((Object)s.getBlankOwner(), (Object)blankOwner)).findFirst().orElse(null);
                if (settings != null) {
                    EntityStorageContext entityStorageContext = new EntityStorageContext();
                    Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)settings.getValidator(), (EntityStorageContext)entityStorageContext);
                    if (validator != null) {
                        String pcc = validator.getPCC() != null ? validator.getPCC().getCode() : null;
                        String validatorCode = validator.getNumber();
                        NestedEntityReference validatorRef = new NestedEntityReference((EntityReference)settings.getValidator(), (BaseEntity)validator);
                        validatorRef.setCaption(validatorCode);
                        ctx.putObject((Enum)IBusProfileContextKeys.PCC, (Object)pcc);
                        ctx.putObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_CODE, (Object)validatorCode);
                        ctx.putObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_REF, (Object)validatorRef);
                        if (validator.getSupplier() == null) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_supplierDefineFailedFromValidator, (Object[])new Object[]{validatorCode}));
                        } else {
                            ctx.putObject((Enum)IbusOneliyaParserContextKeys.SUPPLIER, (Object)validator.getSupplier());
                        }
                        if (validator.getAgency() == null) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_agencyDefineFailedFromValidator, (Object[])new Object[]{validatorCode}));
                        } else {
                            ctx.putObject((Enum)IBusProfileContextKeys.AGENCY, (Object)validator.getAgency());
                        }
                    } else {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_validatorDefineFailed, (Object[])new Object[0]));
                    }
                    EntityContainer salesPointContainer = EntityStorageHelper.resolve((EntityReference)settings.getValidator(), (EntityStorageContext)entityStorageContext);
                    if (salesPointContainer != null) {
                        EntityReference salesPoint = salesPointContainer.toReference();
                        if (((SalesPoint)salesPointContainer.getEntity()).getAgency() == null) {
                            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_subagencyDefineFailedFromSalesPoint, (Object[])new Object[]{((SalesPoint)salesPointContainer.getEntity()).getCode()}));
                        } else {
                            ctx.putObject((Enum)IBusProfileContextKeys.SUBAGENCY, (Object)((SalesPoint)salesPointContainer.getEntity()).getAgency());
                        }
                        ctx.putObject((Enum)IBusProfileContextKeys.SALES_POINT, (Object)salesPoint);
                    } else {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_salesPointDefineFailed, (Object[])new Object[0]));
                    }
                }
            }
        }
        String agentCode = orderItem.getPosSysName();
        if (TextUtil.nonBlank((String)agentCode)) {
            List gdsReferenceIndexes;
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)GdsName.ONELIYA));
            query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)GdsReferenceIndex.Property.reference.name(), (String)agentCode));
            if (createDate != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)createDate), SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null)}));
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)createDate), SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null)}));
            }
            if ((gdsReferenceIndexes = EntityStorage.get().search(GdsReferenceIndex.class, query).getData()).size() == 0) {
                messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_agentDefineFailed, (String)Messages.ParsersHelper_agentWithCodeNotFound, (Object[])new Object[]{agentCode}));
            } else if (gdsReferenceIndexes.size() > 1) {
                messages.add(MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_agentDefineAmbiguous, (String)Messages.ParsersHelper_agentWithCodeMultipleFound, (Object[])new Object[]{agentCode}));
            }
            if (gdsReferenceIndexes.size() > 0) {
                ctx.putObject((Enum)IBusProfileContextKeys.AGENT, (Object)((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getSource());
                Optional.ofNullable(EntityStorage.get().resolve(((GdsReferenceIndex)gdsReferenceIndexes.get(0)).getSource())).flatMap(p -> ((Person)p.getEntity()).getGdsReferences().stream().filter(g -> g.getGdsName() == GdsName.ONELIYA).findFirst()).ifPresent(g -> ctx.putObject((Enum)IBusProfileContextKeys.SALES_POINT, (Object)g.getSalesPoint()));
            }
        } else {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_agentDefineFailed, (Object[])new Object[0]));
        }
        ctx.addMessages(messages);
    }
}

