/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.List;

public class OneliyaFindSellProductForMcoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        OneliyaOrderItemBlank mcoBlank = orderItem.getOrderItemBlanks().stream().findFirst().orElse(null);
        if (mcoBlank == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0431\u043b\u0430\u043d\u043a EMD", (Object[])new Object[0]));
        }
        Product sell = null;
        if (orderItem.getMainOrderItemRoutePartIds() != null && !orderItem.getMainOrderItemRoutePartIds().isEmpty()) {
            sell = products.stream().filter(p -> TextUtil.nonBlank((String)p.getGdsId())).filter(p -> p.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).filter(s -> TextUtil.nonBlank((String)s.getGdsId())).anyMatch(s -> orderItem.getMainOrderItemRoutePartIds().contains(Integer.valueOf(s.getGdsId())))).findFirst().orElse(null);
        }
        if (sell == null) {
            sell = new Product();
            sell.setProductCategory(ProductCategory.AIR);
            sell.setStatus(ProductStatus.SELL);
            sell.setTicketType(TicketType.FAKE);
            SegmentTariff st = new SegmentTariff();
            orderItem.getMainOrderItemRoutePartIds().forEach(id -> {
                Segment segment = new Segment();
                segment.setGdsId(String.valueOf(id));
                st.getSegments().add(segment);
            });
            sell.getSegmentTariffs().add(st);
        }
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.SELL_PRODUCT, (Object)sell);
    }
}

