/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util.OneliyaParserHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.List;

public class OneliyaGetOriginalProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        Product product = products.stream().filter(p -> TextUtil.isSame((String)p.getSystemNumber(), (String)OneliyaParserHelper.convertToSystemNumber(orderItemBlank.getBlankNumber()))).findFirst().orElse(OneliyaParserHelper.createProduct(OneliyaParserHelper.convertToSystemNumber(orderItemBlank.getBlankNumber()), orderItem, ProductCategory.AIR, ProductStatus.SELL, TicketType.FAKE));
        if (!products.contains(product)) {
            products.add(product);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)product);
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.SELL_PRODUCT, (Object)product);
    }
}

