/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import java.util.List;

public class OneliyaHandleReservationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        List productsToRemove = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_TO_REMOVE_LIST);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        EntityReference subagency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        EntityReference salesPoint = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        OneliyaHandleReservationsProcessor.removeProductsFromReservations(productsToRemove);
        OneliyaHandleReservationsProcessor.populateMissingReservations((BookingFile)bookingFileContainer.getEntity(), products, orderItem, (EntityReference<Organization>)subagency, (EntityReference<SalesPoint>)salesPoint, (EntityReference<Person>)agent);
    }

    private static void populateMissingReservations(BookingFile bookingFile, List<Product> products, OneliyaOrderItem orderItem, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, EntityReference<Person> agent) {
        Reservation reservation = OneliyaHandleReservationsProcessor.tryFindExistingReservation(bookingFile, orderItem.getReservationNumber());
        for (Product product : products) {
            if (product.getReservation() != null) continue;
            if (reservation == null) {
                reservation = OneliyaHandleReservationsProcessor.createReservation(orderItem, subagency, salesPoint, agent, bookingFile);
            }
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
        }
    }

    private static Reservation tryFindExistingReservation(BookingFile bookingFile, String reservationNumber) {
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)reservationNumber, (GdsName)GdsName.ONELIYA)) continue;
            return reservation;
        }
        return null;
    }

    private static void removeProductsFromReservations(List<Product> productsToRemove) {
        if (productsToRemove.isEmpty()) {
            return;
        }
        for (Product product : productsToRemove) {
            Reservation reservation = product.getReservation();
            if (reservation == null) continue;
            reservation.getProducts().remove(product);
            product.setReservation(null);
        }
    }

    private static Reservation createReservation(OneliyaOrderItem orderItem, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, EntityReference<Person> agent, BookingFile bookingFile) {
        Reservation reservation = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.ONELIYA, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)orderItem.getReservationNumber());
        reservation.setResDate(orderItem.getCreateDateTime());
        reservation.setSubagency(subagency);
        reservation.setSalesPoint(salesPoint);
        reservation.setBookingAgent(agent);
        reservation.setTimeLimit(orderItem.getPayTimeLimit());
        reservation.setType(ReservationType.OFFLINE);
        BookingHelper.addReservation((BookingFile)bookingFile, (Reservation)reservation);
        return reservation;
    }
}

