/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import java.util.List;
import java.util.Map;

public class OneliyaMergeTravellersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map result = (Map)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.TRAVELLERS_MAP);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (Traveller parsedTraveller : result.values()) {
            Traveller traveller = this.findTravellerByPassport(parsedTraveller, ((BookingFile)bookingCtr.getEntity()).getTravellers());
            if (traveller != null) {
                this.updateTraveller(traveller, parsedTraveller);
                continue;
            }
            traveller = this.findTravellerByName(parsedTraveller, ((BookingFile)bookingCtr.getEntity()).getTravellers());
            if (traveller != null) {
                this.updateTraveller(traveller, parsedTraveller);
                continue;
            }
            ((BookingFile)bookingCtr.getEntity()).getTravellers().add(parsedTraveller);
        }
    }

    private Traveller findTravellerByName(Traveller fromAir, List<Traveller> travellers) {
        String name = fromAir.getName();
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        for (Traveller trav : travellers) {
            if (!TextUtil.isSame((String)trav.getName(), (String)name, (boolean)true)) continue;
            return trav;
        }
        return null;
    }

    private void updateTraveller(Traveller existing, Traveller fromAir) {
        fromAir.setUid(existing.getUid());
        if (existing.getBirthday() == null) {
            existing.setBirthday(fromAir.getBirthday());
        }
        if (existing.getGender() == null) {
            existing.setGender(fromAir.getGender());
        }
        if (existing.getPassport() == null) {
            existing.setPassport(fromAir.getPassport());
        }
    }

    private Traveller findTravellerByPassport(Traveller fromAir, List<Traveller> travellers) {
        Passport passport = fromAir.getPassport();
        if (passport == null || passport.getNumber() == null) {
            return null;
        }
        for (Traveller trav : travellers) {
            if (trav.getPassport() == null || !passport.getNumber().equals(trav.getPassport().getNumber())) continue;
            return trav;
        }
        return null;
    }
}

