/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.oneliya.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderCustomers;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemReport;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class OneliyaParseTravellersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItemReport airFile = (OneliyaOrderItemReport)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.AIR_FILE);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        HashMap<Integer, Traveller> travellers = new HashMap<Integer, Traveller>();
        for (OneliyaOrderCustomers orderCustomer : airFile.getOrderCustomers()) {
            if (orderItem.getOrderItemCustomers().stream().noneMatch(orderItemCustomer -> MiscUtil.equals((Object)orderItemCustomer.getOrderCustomerId(), (Object)orderCustomer.getOrderCustomerId()))) continue;
            Traveller traveller = new Traveller();
            String firstName = TextUtil.nonBlank((String)orderCustomer.getFirstName()) ? orderCustomer.getFirstName().trim() : null;
            String middleName = TextUtil.nonBlank((String)orderCustomer.getMiddleName()) ? orderCustomer.getMiddleName().trim() : null;
            String lastName = TextUtil.nonBlank((String)orderCustomer.getLastName()) ? orderCustomer.getLastName().trim() : null;
            Gender gender = OneliyaModelHelper.getGenderByCode(orderCustomer.getSex());
            Date birthday = orderCustomer.getBirthDate();
            String documentNumber = TextUtil.nonBlank((String)orderCustomer.getDocumentNumber()) ? orderCustomer.getDocumentNumber().trim() : null;
            Date docExpireDate = orderCustomer.getDocumentValidTill();
            PassportType passportType = null;
            if (TextUtil.nonBlank((String)orderCustomer.getDocumentType()) && (passportType = OneliyaModelHelper.getPassportType(orderCustomer.getDocumentType())) == null) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_unsupportedPassportType), (Object[])new Object[0]));
            }
            String citizenshipCode = orderCustomer.getCitizenshipCode();
            DictionaryReference<Country> countryRef = null;
            if (TextUtil.nonBlank((String)citizenshipCode) && (countryRef = OneliyaModelHelper.getCountryRef(citizenshipCode)) == null) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_unsupportedCitizenshipCode), (Object[])new Object[]{citizenshipCode}));
            }
            orderItem.getOrderItemCustomers().stream().filter(oic -> MiscUtil.equals((Object)oic.getOrderCustomerId(), (Object)orderCustomer.getOrderCustomerId())).findFirst().ifPresent(oic -> {
                if (!oic.getFrequentFlyerCards().isEmpty() && !oic.getRemarks().getItems().isEmpty()) {
                    oic.getRemarks().getItems().stream().filter(r -> MiscUtil.equals((Object)r.getOrderCustomedrId(), (Object)orderCustomer.getOrderCustomerId())).filter(r -> MiscUtil.equals((Object)r.getRemarkType(), (Object)"FrequentFlyerCard")).findFirst().ifPresent(i -> DictHelper.getAirlinesByAnyCode((String)oic.getFrequentFlyerCards().get(0).getCardIssuerAirlineCode(), (Date)new Date()).stream().findFirst().ifPresent(a -> {
                        BookingAirlineBonusCard card = new BookingAirlineBonusCard();
                        card.setValid(i.getIsSuccessfullyAdded().booleanValue());
                        card.setNumber(oic.getFrequentFlyerCards().get(0).getCardNumber());
                        card.setAirline((DictionaryReference)a.toReference());
                        traveller.getAirlineBonusCards().add(card);
                    }));
                }
            });
            traveller.setName(TextUtil.join((String)" ", Arrays.asList(lastName, firstName, middleName), (boolean)true));
            traveller.setGender(gender);
            traveller.setBirthday(birthday);
            Passport passport = new Passport();
            passport.setFirstName(firstName);
            passport.setMiddleName(middleName);
            passport.setLastName(lastName);
            passport.setBirthday(birthday);
            passport.setGender(gender);
            passport.setCitizenship(countryRef);
            passport.setExpired(docExpireDate);
            passport.setNumber(documentNumber);
            passport.setType(passportType);
            traveller.setPassport(passport);
            EntityReference person = ProfileHelper.findPerson((Traveller)traveller, null);
            traveller.setPassenger(person);
            travellers.put(orderCustomer.getOrderCustomerId(), traveller);
        }
        ctx.putObject((Enum)IbusOneliyaParserContextKeys.TRAVELLERS_MAP, travellers);
    }
}

