/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import java.util.List;

public class OneliyaReplaceFakeProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        List productsToRemove = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_TO_REMOVE_LIST);
        Product fakeExchange = product.getNextProduct();
        if (!OneliyaReplaceFakeProductProcessor.isProductFakeExchange(fakeExchange)) {
            return;
        }
        Product newExchangeProduct = OneliyaReplaceFakeProductProcessor.createNewExchangeProduct(product);
        productsToRemove.add(fakeExchange);
        products.remove(fakeExchange);
        products.add(newExchangeProduct);
        OneliyaReplaceFakeProductProcessor.linkProducts(product, newExchangeProduct, fakeExchange);
    }

    private static void linkProducts(Product sell, Product exchange, Product fakeExchange) {
        Product nextAfterExchange = fakeExchange.getNextProduct();
        nextAfterExchange.getFares().addAll(sell.getFares());
        nextAfterExchange.getTaxes().addAll(sell.getTaxes());
        nextAfterExchange.getObFees().addAll(sell.getObFees());
        sell.setNextProduct(exchange);
        exchange.setPreviousProduct(sell);
        exchange.setNextProduct(nextAfterExchange);
        nextAfterExchange.setPreviousProduct(exchange);
        fakeExchange.setNextProduct(null);
        fakeExchange.setPreviousProduct(null);
    }

    private static boolean isProductFakeExchange(Product product) {
        return product != null && product.getTicketType() == TicketType.FAKE && product.getStatus() == ProductStatus.EXCHANGE;
    }

    private static Product createNewExchangeProduct(Product product) throws Exception {
        Product exchangeProduct = AirProductHelper.clone((Product)product, (boolean)false);
        exchangeProduct.setStatus(ProductStatus.EXCHANGE);
        exchangeProduct.setContractRulesApplied(false);
        exchangeProduct.setChecked(false);
        exchangeProduct.setPreviousProduct(product);
        exchangeProduct.setTotalVendorEquivalentVatAmount(null);
        exchangeProduct.setVendorVatCalculated(false);
        exchangeProduct.setPenalty(null);
        exchangeProduct.setReservation(null);
        return exchangeProduct;
    }
}

