/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemCustomers;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemRoutePart;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaTrilateralAgreement;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OneliyaTripartiteContractDetailsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        List<OneliyaOrderItemCustomers> orderItemCustomers = orderItem.getOrderItemCustomers();
        Map travellerMap = (Map)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.TRAVELLERS_MAP);
        if (!OneliyaTripartiteContractDetailsProcessor.isTripartiteSegmentPresented(orderItem.getOrderItemRouteParts())) {
            return;
        }
        TripartiteContractDetails tripartiteContractDetails = product.getTripartiteContractDetails();
        tripartiteContractDetails.setIssuedUnder3d(true);
        OneliyaTrilateralAgreement trilateralAgreement = orderItem.getTrilateralAgreement();
        if (trilateralAgreement == null) {
            return;
        }
        Optional.ofNullable(trilateralAgreement.getClientCode()).ifPresent(dn -> {
            product.setDiscountDocumentNumber(dn);
            product.setTourCode(dn);
        });
        Optional.ofNullable(product.getTraveller()).map(traveller -> OneliyaTripartiteContractDetailsProcessor.getCustomerIdByMatchingTraveller(travellerMap, traveller)).map(customerId -> OneliyaTripartiteContractDetailsProcessor.getOneliyaCustomerByCustomerId(orderItemCustomers, customerId)).ifPresent(orderItemCustomer -> {
            Double discountAmount = orderItemCustomer.getDiscountAmount();
            if (discountAmount != null) {
                tripartiteContractDetails.setDiscountValue(BigDecimal.valueOf(discountAmount));
            }
            tripartiteContractDetails.setDiscountRate(orderItemCustomer.getDiscountPercent());
        });
        String tourCode = trilateralAgreement.getTourCode();
        List<EntityReference<Contract>> references = OneliyaTripartiteContractDetailsProcessor.getContractByTourCode(tourCode);
        if (references == null || references.isEmpty()) {
            return;
        }
        EntityReference<Contract> contract = references.get(0);
        tripartiteContractDetails.setContract(contract);
        product.setTourCode(contract.getCaption());
        if (references.size() > 1) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BaseTicketTransactionDataProcessor_foundFewContractWithTourcode, (Object[])new Object[]{tourCode, contract}));
        }
    }

    private static boolean isTripartiteSegmentPresented(List<OneliyaOrderItemRoutePart> routeParts) {
        return routeParts.stream().anyMatch(item -> "TrilateralAgreement".equals(item.getFareDescription().getTariff()));
    }

    private static Integer getCustomerIdByMatchingTraveller(Map<Integer, Traveller> travellers, Traveller targetTraveller) {
        return travellers.entrySet().stream().filter(pair -> pair.getValue() == targetTraveller).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private static OneliyaOrderItemCustomers getOneliyaCustomerByCustomerId(List<OneliyaOrderItemCustomers> orderItemCustomers, Integer travellerId) {
        return orderItemCustomers.stream().filter(customer -> MiscUtil.equals((Object)customer.getOrderCustomerId(), (Object)travellerId, (boolean)false)).findFirst().orElse(null);
    }

    private static List<EntityReference<Contract>> getContractByTourCode(String tourCode) {
        if (TextUtil.isBlank((String)tourCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.tourCode.name(), (Object)tourCode));
        return StorageHelper.getEntityReferences((SearchQuery)query, ContractCustomerIndex.class);
    }
}

