/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.oneliya.l10n.Messages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util.OneliyaParserHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemCustomers;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class OneliyaUpdateAirProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String ticketNumber;
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        EntityReference subagency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        EntityReference agency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENCY);
        EntityReference supplier = (EntityReference)ctx.getObject((Enum)IbusOneliyaParserContextKeys.SUPPLIER);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        EntityReference salesPoint = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        String pcc = (String)ctx.getObject((Enum)IBusProfileContextKeys.PCC);
        String validatorCode = (String)ctx.getObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_CODE);
        NestedEntityReference validatorRef = (NestedEntityReference)ctx.getObject((Enum)IbusOneliyaParserContextKeys.VALIDATOR_REF);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.TRAVELLERS_MAP);
        SegmentTariff segmentTariff = (SegmentTariff)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.SEGMENT_TARIFF);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        product.setEticket(true);
        product.setProductCategory(ProductCategory.AIR);
        product.setTicketType(TicketType.OWN);
        product.setTariffType(TariffType.REGULAR);
        product.setIssueDate(orderItem.getConfirmDateTime());
        product.setEndorsement(orderItemBlank.getEndorsements() != null ? String.join((CharSequence)" ", orderItemBlank.getEndorsements()) : null);
        AirProductHelper.setAgency((Product)product, (EntityReference)agency);
        AirProductHelper.setSubagency((Product)product, (EntityReference)subagency);
        product.setSalesPoint(salesPoint);
        product.setPcc(pcc);
        product.setValidatorCode(validatorCode);
        product.setValidatorRef(validatorRef);
        product.setCashier(agent);
        product.getSegmentTariffs().clear();
        product.getSegmentTariffs().add(segmentTariff);
        product.setGdsId(String.valueOf(orderItemBlank.getOrderItemBlankId()));
        if (product.getSalesOriginContent() == null) {
            OneliyaParserHelper.updateFromServiceProvider(orderItem, product);
        }
        if (product.getStatus() == ProductStatus.REFUND && product.getPreviousProduct() != null && product.getPreviousProduct().getStatisticalData() != null) {
            if (product.getStatisticalData() == null) {
                GeneralProductHelper.getHandler((BaseProduct)product).newStatisticalData((BaseProduct)product);
            }
            product.getPreviousProduct().getStatisticalData().getTravellerCostCodes().forEach(tcc -> tcc.getCostCodes().stream().filter(cc -> product.getStatisticalData().getTravellerCostCodes().stream().filter(tc -> MiscUtil.equals((Object)tc.getTraveller(), (Object)tcc.getTraveller(), (boolean)false)).flatMap(tc -> tc.getCostCodes().stream()).noneMatch(c -> c.getCostCodeProperties().equals((Object)cc.getCostCodeProperties()) && TextUtil.isSame((String)c.getValue(), (String)cc.getValue()))).forEach(cc -> {
                CostCode code = new CostCode();
                code.setCostCodeProperties(cc.getCostCodeProperties());
                code.setValue(cc.getValue());
                code.setEnglishValue(cc.getEnglishValue());
                code.setLocalValue(cc.getLocalValue());
                TravellerCostCodes travellerCostCodes = product.getStatisticalData().getTravellerCostCodes().stream().filter(tc -> MiscUtil.equals((Object)tc.getTraveller(), (Object)tcc.getTraveller(), (boolean)false)).findFirst().orElse(null);
                if (travellerCostCodes == null) {
                    travellerCostCodes = new TravellerCostCodes();
                    travellerCostCodes.setTraveller(tcc.getTraveller());
                    product.getStatisticalData().getTravellerCostCodes().add(travellerCostCodes);
                }
                travellerCostCodes.getCostCodes().add(code);
            }));
        }
        if (TextUtil.nonBlank((String)(ticketNumber = orderItemBlank.getBlankNumber())) && ticketNumber.length() > 3) {
            Airline blankOwnerAirline;
            String validatingCarrierNumber = ticketNumber.substring(0, 3);
            String productNumber = ticketNumber.substring(3);
            product.setCarrierNumber(validatingCarrierNumber);
            product.setSystemNumber(productNumber);
            Airline validatingCarrier = (Airline)CollectionUtil.head((Iterable)DictHelper.getAirlinesByNumber((String)validatingCarrierNumber, (Date)orderItem.getCreateDateTime()));
            if (validatingCarrier != null) {
                product.setCarrier((DictionaryReference)validatingCarrier.toReference());
            }
            if ((blankOwnerAirline = DictHelper.isBspTicket((String)productNumber) ? DictHelper.findAirlineByAnyCode((String)"BSP") : (DictHelper.isTchTicket((String)productNumber) ? DictHelper.findAirlineByAnyCode((String)"\u04281") : validatingCarrier)) != null) {
                product.setBlankOwnerNumber(blankOwnerAirline.getAirlineNumber());
                EntityReference blankOwner = (EntityReference)CollectionUtil.head((Iterable)ProfileDao.getBlankOwnerReferencesByAirline((DictionaryReference)blankOwnerAirline.toReference()));
                if (blankOwner != null) {
                    product.setBlankOwnerRef(blankOwner);
                    BlankType blankType = BookingHelper.getBlankType((String)productNumber, (EntityReference)blankOwner, (ProductCategory)product.getProductCategory(), (boolean)product.isEticket());
                    if (blankType != null) {
                        product.setBlankType((DictionaryReference)blankType.toReference());
                    }
                }
            }
            AirProductHelper.setSupplier((Product)product, (EntityReference)supplier);
            List orderCustomerIds = orderItem.getOrderItemCustomers().stream().filter(customer -> customer.getOrderItemBlankIds().contains(orderItemBlank.getOrderItemBlankId())).map(OneliyaOrderItemCustomers::getOrderCustomerId).collect(Collectors.toList());
            if (orderCustomerIds.size() > 1) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_tooManyTravellers), (Object[])new Object[]{orderItemBlank.getBlankNumber()}));
            } else if (orderCustomerIds.size() == 1) {
                Traveller traveller = (Traveller)travellers.get(orderCustomerIds.get(0));
                ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
                product.setPassengerType((DictionaryReference)orderItem.getOrderItemCustomers().stream().filter(customer -> MiscUtil.equals((Object)customer.getOrderCustomerId(), orderCustomerIds.get(0))).map(OneliyaOrderItemCustomers::getCategory).map(OneliyaModelHelper::getPassengerType).filter(Objects::nonNull).findFirst().orElse(null));
                if (!((BookingFile)bookingFile.getEntity()).getTravellers().contains(traveller)) {
                    ((BookingFile)bookingFile.getEntity()).getTravellers().add(traveller);
                }
            }
            product.getRelatedProducts().stream().filter(relatedProd -> ProductCategory.MCO == relatedProd.getProductCategory()).forEach(relatedProd -> {
                relatedProd.getSegmentTariffs().clear();
                relatedProd.getSegmentTariffs().add(segmentTariff);
                relatedProd.setPassengerType((DictionaryReference)orderItem.getOrderItemCustomers().stream().filter(customer -> MiscUtil.equals((Object)customer.getOrderCustomerId(), orderCustomerIds.get(0))).map(OneliyaOrderItemCustomers::getCategory).map(OneliyaModelHelper::getPassengerType).filter(Objects::nonNull).findFirst().orElse(null));
            });
        }
    }
}

