/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.oneliya.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class OneliyaUpdateBookingFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        ((BookingFile)bookingFile.getEntity()).setCreateDate(orderItem.getConfirmDateTime());
        if (BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).noneMatch(ShipmentHelper::hasClientRelatedShipment) && (((BookingFile)bookingFile.getEntity()).getCustomerProfile() == null || ProfileHelper.isRetailProfile((EntityReference)((BookingFile)bookingFile.getEntity()).getCustomerProfile()))) {
            HashSet clientOrganizations = new HashSet();
            for (Traveller traveller : ((BookingFile)bookingFile.getEntity()).getTravellers()) {
                EntityReference personRef = traveller.getPassenger();
                EntityContainer person = EntityStorage.get().resolve(personRef);
                if (person == null) continue;
                List<EntityReference<Organization>> personEmployments = OneliyaUpdateBookingFileProcessor.getPersonEmployments((Person)person.getEntity(), orderItem.getCreateDateTime(), true);
                if (personEmployments.isEmpty()) {
                    personEmployments = OneliyaUpdateBookingFileProcessor.getPersonEmployments((Person)person.getEntity(), orderItem.getCreateDateTime(), false);
                }
                personEmployments.stream().findFirst().ifPresent(clientOrganizations::add);
            }
            if (clientOrganizations.isEmpty()) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_noClientOrganization), (Object[])new Object[0]));
            } else if (clientOrganizations.size() > 1) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.OneliyaParser_tooManyClientOrganization), (Object[])new Object[0]));
            }
            clientOrganizations.stream().findFirst().ifPresent(arg_0 -> ((BookingFile)((BookingFile)bookingFile.getEntity())).setCustomerProfile(arg_0));
        }
    }

    private static List<EntityReference<Organization>> getPersonEmployments(Person person, Date issueDate, boolean onlyMainEmployments) {
        ArrayList<EntityReference<Organization>> res = new ArrayList<EntityReference<Organization>>();
        if (person == null) {
            return res;
        }
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe.getOrganization() == null || !MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)issueDate) || onlyMainEmployments && !pe.isMainEmployment()) continue;
            res.add((EntityReference<Organization>)pe.getOrganization());
        }
        return res;
    }
}

