/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util.OneliyaParserHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.List;

public class OneliyaUpdateExchangeProductChainProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        String previousSystemNumber = OneliyaParserHelper.convertToSystemNumber(orderItemBlank.getPreviousBlankNumber());
        String currentSystemNumber = OneliyaParserHelper.convertToSystemNumber(orderItemBlank.getBlankNumber());
        String previousGdsId = String.valueOf(orderItemBlank.getPreviousOrderItemBlankId());
        String currentGdsId = String.valueOf(orderItemBlank.getOrderItemBlankId());
        Product sellProduct = OneliyaUpdateExchangeProductChainProcessor.findProduct(products, previousGdsId, previousSystemNumber, ProductStatus.SELL);
        Product exchangeProduct = OneliyaUpdateExchangeProductChainProcessor.findProduct(products, previousGdsId, previousSystemNumber, ProductStatus.EXCHANGE);
        Product sellOverExchangeProduct = OneliyaUpdateExchangeProductChainProcessor.findProduct(products, currentGdsId, currentSystemNumber, ProductStatus.SELL);
        if (sellProduct == null) {
            sellProduct = OneliyaParserHelper.createProduct(previousSystemNumber, orderItem, OneliyaUpdateExchangeProductChainProcessor.getProductCategoryFromOrderItemType(orderItem.getType()), ProductStatus.SELL, TicketType.FAKE);
            products.add(sellProduct);
        }
        if (exchangeProduct == null) {
            exchangeProduct = OneliyaUpdateExchangeProductChainProcessor.cloneAsExchangeProduct(sellProduct);
            products.add(exchangeProduct);
        }
        if (sellOverExchangeProduct == null) {
            sellOverExchangeProduct = OneliyaParserHelper.createProduct(null, orderItem, ProductCategory.AIR, ProductStatus.SELL, TicketType.OWN);
            products.add(sellOverExchangeProduct);
        }
        sellProduct.setNextProduct(exchangeProduct);
        exchangeProduct.setPreviousProduct(sellProduct);
        exchangeProduct.setNextProduct(sellOverExchangeProduct);
        sellOverExchangeProduct.setPreviousProduct(exchangeProduct);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)sellOverExchangeProduct);
    }

    private static Product findProduct(List<Product> products, String productGdsId, String productSystemNumber, ProductStatus productStatus) {
        return products.stream().filter(product -> TextUtil.equals((String)product.getSystemNumber(), (String)productSystemNumber, (boolean)false) && product.getStatus() == productStatus).findFirst().orElse(null);
    }

    private static Product cloneAsExchangeProduct(Product originalProduct) throws Exception {
        Product exchangeProduct = AirProductHelper.clone((Product)originalProduct, (boolean)true);
        exchangeProduct.setStatus(ProductStatus.EXCHANGE);
        exchangeProduct.setContractRulesApplied(false);
        exchangeProduct.setChecked(false);
        exchangeProduct.setTotalVendorEquivalentVatAmount(null);
        exchangeProduct.setVendorVatCalculated(false);
        exchangeProduct.setPenalty(null);
        return exchangeProduct;
    }

    private static ProductCategory getProductCategoryFromOrderItemType(String orderItemType) throws Exception {
        if (orderItemType == null) {
            throw Xeption.forEndUser((String)"Unable to resolve product category as orderItemType is null", (Object[])new Object[0]);
        }
        if (orderItemType.contains("AviaFullOrder")) {
            return ProductCategory.AIR;
        }
        if (orderItemType.contains("AviaAdditionalService")) {
            return ProductCategory.MCO;
        }
        throw Xeption.forEndUser((String)"Unable to resolve product category for {0}", (Object[])new Object[]{orderItemType});
    }
}

