/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.IbusOneliyaParserContextKeys;
import com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util.OneliyaParserHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import java.util.List;

public class OneliyaUpdateRefundProductChainProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.PRODUCT_LIST);
        OneliyaOrderItemBlank orderItemBlank = (OneliyaOrderItemBlank)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM_BLANK);
        OneliyaOrderItem orderItem = (OneliyaOrderItem)ctx.getMandatoryObject((Enum)IbusOneliyaParserContextKeys.ORDER_ITEM);
        String previousSystemNumber = OneliyaUpdateRefundProductChainProcessor.convertToSystemNumber(orderItemBlank.getPreviousBlankNumber());
        String currentSystemNumber = OneliyaUpdateRefundProductChainProcessor.convertToSystemNumber(orderItemBlank.getBlankNumber());
        Product sellProduct = OneliyaUpdateRefundProductChainProcessor.findProduct(products, previousSystemNumber, ProductStatus.SELL);
        Product refundProduct = OneliyaUpdateRefundProductChainProcessor.findProduct(products, currentSystemNumber, ProductStatus.REFUND);
        if (sellProduct == null) {
            sellProduct = OneliyaUpdateRefundProductChainProcessor.createProduct(previousSystemNumber, orderItem, OneliyaUpdateRefundProductChainProcessor.getProductCategoryFromOrderItemType(orderItem.getType()), ProductStatus.SELL, TicketType.FAKE);
            products.add(sellProduct);
        }
        if (refundProduct == null) {
            refundProduct = OneliyaUpdateRefundProductChainProcessor.createProduct(null, orderItem, ProductCategory.AIR, ProductStatus.REFUND, TicketType.OWN);
            products.add(refundProduct);
        }
        sellProduct.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(sellProduct);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)refundProduct);
    }

    private static Product findProduct(List<Product> products, String productSystemNumber, ProductStatus productStatus) {
        return products.stream().filter(product -> TextUtil.equals((String)product.getSystemNumber(), (String)productSystemNumber, (boolean)false) && product.getStatus() == productStatus).findFirst().orElse(null);
    }

    private static String convertToSystemNumber(String blankNumber) {
        if (blankNumber != null) {
            return blankNumber.substring(3);
        }
        return blankNumber;
    }

    private static Product createProduct(String previousTicketNumber, OneliyaOrderItem orderItem, ProductCategory category, ProductStatus status, TicketType ticketType) {
        Product product = new Product();
        product.setSystemNumber(previousTicketNumber);
        product.setStatus(status);
        product.setTicketType(ticketType);
        product.setProductCategory(category);
        OneliyaParserHelper.updateFromServiceProvider(orderItem, product);
        return product;
    }

    private static ProductCategory getProductCategoryFromOrderItemType(String orderItemType) throws Exception {
        if (orderItemType == null) {
            throw Xeption.forEndUser((String)"Unable to resolve product category as orderItemType is null", (Object[])new Object[0]);
        }
        if (orderItemType.contains("AviaFullOrder")) {
            return ProductCategory.AIR;
        }
        if (orderItemType.contains("AviaAdditionalService")) {
            return ProductCategory.MCO;
        }
        throw Xeption.forEndUser((String)"Unable to resolve product category for {0}", (Object[])new Object[]{orderItemType});
    }
}

