/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.process.util;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaServiceProvider;

public class OneliyaParserHelper {
    public static void updateFromServiceProvider(OneliyaOrderItem orderItem, Product product) {
        String orderItemServiceProvider = orderItem.getServiceProvider();
        if (orderItemServiceProvider == null) {
            return;
        }
        OneliyaServiceProvider serviceProvider = OneliyaServiceProvider.fromString(orderItemServiceProvider);
        if (serviceProvider == null) {
            return;
        }
        switch (serviceProvider) {
            case AEROFLOT: 
            case S7AIRLINES: 
            case SIG: {
                product.setSalesOriginProvider(SalesOriginProvider.DIRECT_CHANNEL);
                product.setSalesOriginContent(SalesOriginContent.DIRECT_CHANNEL);
                break;
            }
            case SIRENA: {
                product.setSalesOriginProvider(SalesOriginProvider.SIRENA);
                product.setSalesOriginContent(SalesOriginContent.SIRENA);
                break;
            }
            case SABRE: {
                product.setSalesOriginProvider(SalesOriginProvider.SABRE);
                product.setSalesOriginContent(SalesOriginContent.SABRE);
                break;
            }
            case AMADEUS: {
                product.setSalesOriginProvider(SalesOriginProvider.AMADEUS);
                product.setSalesOriginContent(SalesOriginContent.AMADEUS);
                break;
            }
            case MIXVEL: {
                product.setSalesOriginProvider(SalesOriginProvider.MIXVEL);
                product.setSalesOriginContent(SalesOriginContent.MIXVEL);
            }
        }
    }

    public static String convertToSystemNumber(String blankNumber) {
        if (blankNumber != null) {
            return blankNumber.substring(3);
        }
        return blankNumber;
    }

    public static Product createProduct(String ticketNumber, OneliyaOrderItem orderItem, ProductCategory category, ProductStatus status, TicketType ticketType) {
        Product product = new Product();
        product.setSystemNumber(ticketNumber);
        product.setStatus(status);
        product.setTicketType(ticketType);
        product.setProductCategory(category);
        OneliyaParserHelper.updateFromServiceProvider(orderItem, product);
        return product;
    }
}

