/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.ibus.registration;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.oneliya.model.OneliyaExchangeDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.oneliya.model.OneliyaModelHelper;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemBlank;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItemReport;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class OneliyaParserRegisterExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        byte[] content = (byte[])ctx.getObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        OneliyaOrderItemReport orderItemReport = (OneliyaOrderItemReport)OneliyaModelHelper.MAPPER.readValue(content, OneliyaOrderItemReport.class);
        OneliyaExchangeDocument doc = new OneliyaExchangeDocument();
        doc.setStatus(ProcessingStatus.UNPROCESSED);
        doc.setContentType(ContentType.JSON);
        doc.setCreated(new Date());
        doc.setDescription("Oneliya booking info");
        doc.setTitle("Oneliya booking info");
        doc.setContent(content);
        if (orderItemReport != null) {
            OneliyaOrderItem orderItem = orderItemReport.getOrderItem();
            if (!OneliyaParserRegisterExchangeDocumentProcessor.isSupportedStatus(orderItem)) {
                return;
            }
            doc.setIssueDate(orderItem.getConfirmDateTime());
            doc.setTransactionType(OneliyaModelHelper.getTransactionType(orderItem));
            doc.setPnrLocator(orderItem.getReservationNumber());
            doc.getTicketNumbers().addAll(orderItem.getOrderItemBlanks().stream().map(OneliyaOrderItemBlank::getBlankNumber).collect(Collectors.toList()));
            if (orderItemReport.getOrderCustomers() != null) {
                orderItemReport.getOrderCustomers().forEach(customer -> doc.getTravellers().add(customer.getLastName() + " " + customer.getFirstName() + " " + customer.getMiddleName()));
            }
        }
        ctx.putObject((Enum)IBusParsersContextKeys.CHECK_SUM, (Object)DigestUtils.md5Hex((byte[])doc.getContent()));
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST, Collections.singletonList(doc));
    }

    private static boolean isSupportedStatus(OneliyaOrderItem orderItem) {
        if (orderItem == null) {
            return false;
        }
        if (TextUtil.contains((String)orderItem.getType(), (String)"AviaFullOrder") || TextUtil.contains((String)orderItem.getType(), (String)"AviaAdditionalService")) {
            return TextUtil.contains((String)orderItem.getDetailedOperationStatus(), (String)"Succeeded") || TextUtil.contains((String)orderItem.getDetailedOperationStatus(), (String)"Voided") || TextUtil.contains((String)orderItem.getDetailedOperationStatus(), (String)"Canceled");
        }
        return false;
    }
}

