/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.oneliya.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.oneliya.model.order.OneliyaOrderItem;
import java.util.Set;
import java.util.TimeZone;

public class OneliyaModelHelper {
    public static final String ONELYA_CURRENCY_CODE = "RUB";
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static TransactionType getTransactionType(OneliyaOrderItem orderItem) {
        if (orderItem == null) {
            return null;
        }
        ProductStatus status = OneliyaModelHelper.getProductStatus(orderItem);
        if (status == null) {
            return null;
        }
        switch (status) {
            case SELL: {
                return TransactionType.SELL;
            }
            case REFUND: {
                return TransactionType.REFUND;
            }
            case EXCHANGE: {
                return TransactionType.EXCHANGE;
            }
            case VOID: {
                return TransactionType.CANCEL;
            }
            case VOID_BOOKING: {
                return TransactionType.CANCEL_BOOKING;
            }
        }
        return null;
    }

    public static ProductStatus getProductStatus(OneliyaOrderItem orderItem) {
        if (orderItem == null) {
            return null;
        }
        if ("Voided".equals(orderItem.getDetailedOperationStatus())) {
            return ProductStatus.VOID;
        }
        if ("Canceled".equals(orderItem.getDetailedOperationStatus())) {
            return ProductStatus.VOID_BOOKING;
        }
        if ("Succeeded".equals(orderItem.getDetailedOperationStatus())) {
            switch (orderItem.getOperationType()) {
                case "Purchase": {
                    return ProductStatus.SELL;
                }
                case "Return": {
                    return ProductStatus.REFUND;
                }
                case "Exchange": {
                    return ProductStatus.EXCHANGE;
                }
            }
        }
        return null;
    }

    public static ClassOfService getServiceClass(String serviceClass) {
        switch (serviceClass) {
            case "Economic": 
            case "Economy": {
                return ClassOfService.ECONOMY;
            }
            case "Business": {
                return ClassOfService.BUSINESS;
            }
            case "First": {
                return ClassOfService.FIRST;
            }
        }
        return null;
    }

    public static Gender getGenderByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        if (TextUtil.isSame((String)code, (String)"Male", (boolean)true)) {
            return Gender.MALE;
        }
        if (TextUtil.isSame((String)code, (String)"Female", (boolean)true)) {
            return Gender.FEMALE;
        }
        return null;
    }

    public static PassportType getPassportType(String passportTypeCode) {
        if (TextUtil.isBlank((String)passportTypeCode)) {
            return null;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"RussianPassport", (boolean)true)) {
            return PassportType.INTERNAL;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"RussianForeignPassport", (boolean)true)) {
            return PassportType.FOREIGN;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"ForeignPassport", (boolean)true)) {
            return PassportType.PASSPORT;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"BirthCertificate", (boolean)true)) {
            return PassportType.BIRTHDAY_NOTIFICATION;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"MilitaryCard", (boolean)true)) {
            return PassportType.MILITARYID;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"MilitaryOfficerCard", (boolean)true)) {
            return PassportType.MILITARYCERTIFICATE;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"ReturnToCisCertificate", (boolean)true)) {
            return PassportType.BACKTOUSSRCERTIFICATE;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"DiplomaticPassport", (boolean)true)) {
            return PassportType.DIPLOMATIC;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"ServicePassport", (boolean)true)) {
            return PassportType.SERVICE_PASSPORT;
        }
        if (TextUtil.isSame((String)passportTypeCode, (String)"SailorPassport", (boolean)true)) {
            return PassportType.SEAMANSID;
        }
        return null;
    }

    public static DictionaryReference<Country> getCountryRef(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Set countries = DictHelper.findCountryByCode((String)code.trim());
        return countries.isEmpty() ? null : ((Country)countries.iterator().next()).toReference();
    }

    public static PaymentType getPaymentType(String paymentForm) {
        switch (paymentForm) {
            case "Cash": {
                return PaymentType.CASH;
            }
            case "Card": {
                return PaymentType.CREDIT_CARD;
            }
        }
        return PaymentType.INVOICE;
    }

    public static DictionaryReference<PassengerType> getPassengerType(String passengerType) {
        switch (passengerType) {
            case "Adult": {
                return DictHelper.getAdultPassengerType();
            }
            case "Child": {
                return DictHelper.getChildPassengerType();
            }
            case "BabyWithPlace": {
                return DictHelper.getInfantWithSeatPassengerType();
            }
            case "BabyWithoutPlace": {
                return DictHelper.getInfantPassengerType();
            }
            case "Youth": {
                return DictHelper.getYouthPassengerType();
            }
            case "Senior": {
                return DictHelper.getSeniorPassengerType();
            }
        }
        return null;
    }

    public static Double getVatRate(String onelyaVatType) {
        switch (onelyaVatType) {
            case "Standard": {
                return 20.0;
            }
            case "Reduced": {
                return 10.0;
            }
            case "Null": {
                return 0.0;
            }
        }
        return null;
    }

    public static MCOCategory getMcoCategory(String additionalServiceType) {
        switch (additionalServiceType) {
            case "Animal": {
                return MCOCategory.ANIMALS;
            }
            case "Baggage": {
                return MCOCategory.EXCESS_LUGGAGE;
            }
            case "Meal": {
                return MCOCategory.SPECIAL_FOOD;
            }
            case "PlaceSelection": {
                return MCOCategory.SEAT_RESERVATION;
            }
        }
        return null;
    }

    static {
        MAPPER.setTimeZone(TimeZone.getDefault());
    }
}

