/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.portbilet.model.PortbiletParserBlankTypeSettings;
import com.gridnine.xtrip.common.parsers.portbilet.model.PortbiletParserSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PortbiletHelper {
    private static final String SUPPLIER_CODE = "Portbilet";
    private static final String COMMISSION_PROPERTIES = "com.gridnine.xtrip.common.model.booking.commission.CommissionProperties";

    public static EntityReference<Organization> findSupplier() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.externalCodes.name(), (Object)SUPPLIER_CODE));
        List searchResult = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (searchResult.isEmpty()) {
            throw Xeption.forEndUser((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u043f\u043e \u043a\u043e\u0434\u0443 \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b Portbilet", (Object[])new Object[0]);
        }
        if (searchResult.size() > 1) {
            throw Xeption.forEndUser((String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043f\u043e \u043a\u043e\u0434\u0443 \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b Portbilet", (Object[])new Object[0]);
        }
        return ((OrganizationIndex)searchResult.get(0)).getSource();
    }

    public static DictionaryReference<BlankType> getBlankType(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper, MessageContext ctx) {
        boolean active;
        PortbiletParserSettings settings = PortbiletHelper.getSettings();
        PortbiletOrderItem.BlankTypeWrapper blankTypeWrapper = orderItem.getBlankTypes().get(productWrapper.getBlankTypeUid());
        boolean bl = active = settings != null && settings.isActive();
        if (blankTypeWrapper != null) {
            String code;
            EntityReference<Organization> blankTypeOwner;
            DictionaryReference blankType;
            if (!(active && settings.isIgnoreParser() || (blankType = DictHelper.getBlankType(blankTypeOwner = orderItem.getOrganizations().get(blankTypeWrapper.getOwnerUid()), (String)blankTypeWrapper.getName(), (ProductCategory)blankTypeWrapper.getProductCategory(), (BlankCategory)blankTypeWrapper.getBlankCategory())) == null)) {
                return blankType;
            }
            if (active && TextUtil.nonBlank((String)(code = blankTypeWrapper.getCode()))) {
                List types = settings.getBlankTypeSettings().stream().filter(s -> s.getPortbiletCodes().stream().anyMatch(c -> TextUtil.isSame((String)code, (String)c, (boolean)true, (boolean)true))).map(PortbiletParserBlankTypeSettings::getBlankType).collect(Collectors.toList());
                if (types.size() > 0) {
                    if (types.size() > 1) {
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"PortbiletParser_tooManyBlankTypes", (Object[])new Object[]{code}));
                    }
                    return (DictionaryReference)types.get(0);
                }
                types = settings.getBlankTypeSettings().stream().filter(s -> s.getPortbiletCodes().stream().filter(c -> c.contains("*")).anyMatch(c -> Pattern.matches(c.replaceAll("\\*", ".*"), code))).map(PortbiletParserBlankTypeSettings::getBlankType).collect(Collectors.toList());
                if (types.size() > 0) {
                    if (types.size() > 1) {
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"PortbiletParser_tooManyBlankTypes", (Object[])new Object[]{code}));
                    }
                    return (DictionaryReference)types.get(0);
                }
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"PortbiletParser_noBlankTypes", (Object[])new Object[]{code}));
            }
        }
        if (active) {
            return settings.getDefaultBlankType();
        }
        return null;
    }

    public static NestedEntityReference<SalesPoint, Validator> getValidatorRef(BaseProduct product) {
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        String code = productHandler.getValidatorNumber(product);
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        ValidatorIndex validatorIndex = ValidatorHelper.getValidatorIndex((String)code, (EntityReference)productHandler.getBlankOwner(product), (String)productHandler.getPCC(product), (Date)productHandler.findIssueDate(product));
        if (validatorIndex != null) {
            return new NestedEntityReference(validatorIndex.getSource(), validatorIndex.getNavigationKey(), Validator.class, null);
        }
        return null;
    }

    public static VatDetalization getVendorVatDetalization(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper) {
        PortbiletOrderItem.VendorVatDetalizationWrapper vendorVatDetalizationWrapper = orderItem.getVendorVatDetalizations().get(productWrapper.getVendorVatDetalizationUid());
        VatDetalization vatDetalization = new VatDetalization();
        if (vendorVatDetalizationWrapper != null) {
            vatDetalization.setDetalized(vendorVatDetalizationWrapper.isDetalized());
            List<String> vatComponentUids = vendorVatDetalizationWrapper.getVatComponentUids();
            for (String vatComponentUid : vatComponentUids) {
                VatComponent vatComponent = orderItem.getVatComponents().get(vatComponentUid);
                ArrayList<String> taxesUids = new ArrayList<String>();
                for (String taxUid : vatComponent.getTaxesUids()) {
                    if (orderItem.getAirTaxes().get(taxUid) != null) {
                        taxesUids.add(orderItem.getAirTaxes().get(taxUid).getTax().getUid());
                    }
                    if (orderItem.getRailwayTaxes().get(taxUid) != null) {
                        taxesUids.add(orderItem.getRailwayTaxes().get(taxUid).getTax().getUid());
                    }
                    if (orderItem.getHotelTaxes().get(taxUid) == null) continue;
                    taxesUids.add(orderItem.getHotelTaxes().get(taxUid).getTax().getUid());
                }
                vatComponent.getTaxesUids().clear();
                vatComponent.getTaxesUids().addAll(taxesUids);
                vatDetalization.getComponents().add(vatComponent);
            }
        }
        return vatDetalization;
    }

    public static Map<String, RailwaySegment> getRailwaySegments(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper) {
        HashMap<String, RailwaySegment> segments = new HashMap<String, RailwaySegment>();
        for (String segmentUid : productWrapper.getSegmentUids()) {
            PortbiletOrderItem.RailwaySegmentWrapper railwaySegmentWrapper = orderItem.getRailwaySegments().get(segmentUid);
            RailwaySegment segment = railwaySegmentWrapper.getSegment();
            segment.setDepartureStation(orderItem.getRailwayStations().get(railwaySegmentWrapper.getDepartureStationUid()));
            segment.setArriveStation(orderItem.getRailwayStations().get(railwaySegmentWrapper.getArriveStationUid()));
            segment.setFare(orderItem.getMoney().get(railwaySegmentWrapper.getFareUid()));
            segment.setCarrier(orderItem.getRailwayCarriers().get(railwaySegmentWrapper.getCarrierUid()));
            segment.setRoute(orderItem.getRailwayRoutes().get(railwaySegmentWrapper.getRouteUid()));
            segments.put(segmentUid, segment);
        }
        return segments;
    }

    public static FopItem createFopItem(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper, BigDecimal fopAmount) {
        FopItem fopItem = new FopItem();
        fopItem.setAmount(fopAmount);
        for (String contractRelationUid : productWrapper.getContractRelationUids()) {
            PortbiletOrderItem.ContractRelationWrapper wrapper = orderItem.getContractRelationData().get(contractRelationUid);
            EntityReference<ContractRelationDescription> relationDescription = orderItem.getRelationDescriptions().get(wrapper.getDescriptionUid());
            if (GeneralProductHelper.getContractType(relationDescription) != ContractType.CLIENT) continue;
            wrapper.getProductFopUids().stream().map(fopUid -> orderItem.getProductFops().get(fopUid)).map(Fop::getType).filter(type -> type != PaymentType.TICKET).findFirst().ifPresent(arg_0 -> ((FopItem)fopItem).setPaymentType(arg_0));
        }
        return fopItem;
    }

    public static List<GeneralProductCommission> getSubagentCommissions(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper) {
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        for (String contractRelationUid : productWrapper.getContractRelationUids()) {
            PortbiletOrderItem.ContractRelationWrapper contractRelationWrapper = orderItem.getContractRelationData().get(contractRelationUid);
            EntityReference<ContractRelationDescription> relationDescription = orderItem.getRelationDescriptions().get(contractRelationWrapper.getDescriptionUid());
            if (GeneralProductHelper.getContractType(relationDescription) != ContractType.SUBAGENCY) continue;
            for (String productCommissionUid : contractRelationWrapper.getProductCommissionUids()) {
                PortbiletOrderItem.ProductCommissionWrapper productCommissionWrapper = orderItem.getProductCommissions().get(productCommissionUid);
                if (!COMMISSION_PROPERTIES.equals(productCommissionWrapper.getCommissionPropertiesType())) continue;
                GeneralProductCommission commission = productCommissionWrapper.getProductCommission();
                commission.setContractType(ContractType.VENDOR);
                commission.setCommissionProperties(ProfileHelper.getSupplierCommissionProperties().toReference());
                commissions.add(commission);
            }
        }
        return commissions;
    }

    public static DictionaryReference<PassengerType> getPassengerType(PortbiletOrderItem orderItem, String passengerTypeUid) {
        PortbiletOrderItem.PassengerTypeWrapper passengerTypeWrapper = orderItem.getPassengerTypes().get(passengerTypeUid);
        if (passengerTypeWrapper != null) {
            if (passengerTypeWrapper.getPassengerType() != null) {
                return passengerTypeWrapper.getPassengerType();
            }
            DictionaryReference<PassengerTypeCategory> passengerTypeCategory = orderItem.getPassengerTypeCategories().get(passengerTypeWrapper.getPassengerTypeCategoryUid());
            if (DictHelper.isAdultPassengerCategory(passengerTypeCategory)) {
                return DictHelper.getAdultPassengerType();
            }
            if (DictHelper.isChildPassengerCategory(passengerTypeCategory)) {
                return DictHelper.getChildPassengerType();
            }
            if (DictHelper.isInfantPassengerCategory(passengerTypeCategory)) {
                return DictHelper.getInfantPassengerType();
            }
        }
        return null;
    }

    public static PortbiletParserSettings getSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(PortbiletParserSettings.class.getName());
        EntityContainer settings = EntityStorage.get().load(PortbiletParserSettings.class, settingsUid);
        return EntityStorageHelper.nonEmpty((EntityContainer)settings) ? (PortbiletParserSettings)settings.getEntity() : null;
    }
}

