/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.RateType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.AircraftReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.LuggageUnitReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.PrincipalReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRouteReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescriptionIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PortbiletFileReader
extends BaseProcessor {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void process(MessageContext ctx) throws Exception {
        byte[] content = (byte[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        PortbiletOrderItem orderItem = new PortbiletOrderItem();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(new ByteArrayInputStream(content));
        while (reader.hasNext()) {
            if (reader.next() != 1) continue;
            switch (reader.getLocalName()) {
                case "bookingFile": {
                    this.readBookingFile(reader, orderItem);
                    break;
                }
                case "entity": {
                    this.readEntity(reader, orderItem);
                    break;
                }
                case "dictionary": {
                    this.readDictionary(reader, orderItem);
                }
            }
        }
        ctx.putObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM, (Object)orderItem);
    }

    private void readDictionary(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, EnumUtil.NoSuchEnumValueException {
        switch (reader.getAttributeValue(0)) {
            case "com.gridnine.xtrip.common.model.dict.GeoLocation": {
                this.readGeoLocation(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.Airline": {
                this.readAirline(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.Aircraft": {
                this.readAircraft(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.Country": {
                this.readCountry(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.BlankType": {
                this.readBlankType(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.PassengerType": {
                this.readPassengerType(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.PassengerTypeCategory": {
                this.readPassengerTypeCategory(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier": {
                this.readRailwayCarrier(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.railway.RailwayStation": {
                this.readRailwayStation(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.railway.RailwayRoute": {
                this.readRailwayRoute(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.Principal": {
                this.readPrincipal(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.dict.LuggageUnit": {
                this.readLuggageUnit(reader, orderItem);
            }
        }
    }

    private void readAirline(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getAirlines().put(uid, (DictionaryReference<Airline>)new AirlineReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readAircraft(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getBoards().put(uid, (DictionaryReference<Aircraft>)new AircraftReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readRailwayCarrier(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getRailwayCarriers().put(uid, (DictionaryReference<RailwayCarrier>)new RailwayCarrierReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readRailwayStation(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getRailwayStations().put(uid, (DictionaryReference<RailwayStation>)new RailwayStationReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readRailwayRoute(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getRailwayRoutes().put(uid, (DictionaryReference<RailwayRoute>)new RailwayRouteReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readPrincipal(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getPrincipals().put(uid, (DictionaryReference<Principal>)new PrincipalReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readLuggageUnit(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getLuggageUnits().put(uid, (DictionaryReference<LuggageUnit>)new LuggageUnitReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readBlankType(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, EnumUtil.NoSuchEnumValueException {
        String uid = reader.getAttributeValue(1).trim();
        PortbiletOrderItem.BlankTypeWrapper wrapper = new PortbiletOrderItem.BlankTypeWrapper();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "blankOwner": {
                            wrapper.setOwnerUid(reader.getAttributeValue(2));
                            break;
                        }
                        case "code": {
                            wrapper.setCode(this.getText(reader));
                            break;
                        }
                        case "name": {
                            wrapper.setName(this.getText(reader));
                            break;
                        }
                        case "productCategory": {
                            wrapper.setProductCategory((ProductCategory)EnumUtil.fromName(ProductCategory.class, (String)this.getText(reader)));
                            break;
                        }
                        case "blankCategory": {
                            wrapper.setBlankCategory((BlankCategory)EnumUtil.fromName(BlankCategory.class, (String)this.getText(reader)));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    orderItem.getBlankTypes().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readPassengerType(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        uid = reader.getAttributeValue(1).trim();
        wrapper = new PortbiletOrderItem.PassengerTypeWrapper();
        codesMap = new HashMap<CodeSystem, String>();
lbl4:
        // 4 sources

        block12: while (reader.hasNext()) {
            event = reader.next();
            switch (event) {
                case 1: {
                    var7_7 = reader.getLocalName();
                    var8_8 = -1;
                    switch (var7_7.hashCode()) {
                        case 770430363: {
                            if (!var7_7.equals("codeVariants")) break;
                            var8_8 = 0;
                            break;
                        }
                        case 1296516636: {
                            if (!var7_7.equals("categories")) break;
                            var8_8 = 1;
                        }
                    }
                    block8 : switch (var8_8) {
                        case 0: {
                            while (reader.hasNext()) {
                                event = reader.next();
                                if (event == 1 && "item".equals(reader.getLocalName())) {
                                    codeSystem = (CodeSystem)EnumUtil.fromNameSafe(CodeSystem.class, (String)reader.getAttributeValue(null, "codeSystem"), (boolean)false);
                                    if (codeSystem == null) continue;
                                    codesMap.put(codeSystem, this.getText(reader));
                                    continue;
                                }
                                if (event != 2 || !"codeVariants".equals(reader.getLocalName())) continue;
                                break block8;
                            }
                            ** GOTO lbl4
                        }
                        case 1: {
                            while (reader.hasNext()) {
                                event = reader.next();
                                if (event != 1 || !"item".equals(reader.getLocalName())) continue;
                                wrapper.setPassengerTypeCategoryUid(reader.getAttributeValue(1).trim());
                                break block8;
                            }
                            break block8;
                        }
                    }
                    continue block12;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    passengerType = DictHelper.getPassengerTypeByCodeVariant((String)((String)codesMap.get(CodeSystem.IATA)), (CodeSystem)CodeSystem.IATA);
                    if (passengerType == null) {
                        passengerType = DictHelper.getPassengerTypeByCodeVariant((String)((String)codesMap.get(CodeSystem.CRT)), (CodeSystem)CodeSystem.CRT);
                    }
                    wrapper.setPassengerType((DictionaryReference<PassengerType>)passengerType);
                    orderItem.getPassengerTypes().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readPassengerTypeCategory(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getPassengerTypeCategories().put(uid, (DictionaryReference<PassengerTypeCategory>)new PassengerTypeCategoryReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readCountry(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getCountries().put(uid, (DictionaryReference<Country>)new CountryReference(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"dictionary".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readEntity(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException, EnumUtil.NoSuchEnumValueException {
        switch (reader.getAttributeValue(0)) {
            case "com.gridnine.xtrip.common.model.profile.Person": {
                this.readPerson(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.Product": {
                this.readProduct(reader, orderItem, Product.class.getName());
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.RailwayProduct": {
                this.readProduct(reader, orderItem, RailwayProduct.class.getName());
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct": {
                this.readProduct(reader, orderItem, RailwayMcoProduct.class.getName());
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct": {
                this.readProduct(reader, orderItem, HotelProduct.class.getName());
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.Reservation": {
                this.readReservation(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.Customer": {
                this.readCustomer(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.profile.Organization": {
                this.readOrganization(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.SegmentTariff": {
                this.readSegmentTariff(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.Segment": {
                this.readSegment(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.RailwaySegment": {
                this.readRailwaySegment(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.ProductFare": {
                this.readProductFare(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.Tax": {
                this.readTax(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.LuggageInfo": {
                this.readLuggageInfo(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.RailwayTax": {
                this.readRailwayTax(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.Traveller": {
                this.readTraveller(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData": 
            case "com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData": 
            case "com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData": 
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData": {
                this.readProductContractRelationData(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.air.Commission": 
            case "com.gridnine.xtrip.common.model.booking.GeneralProductCommission": {
                this.readProductCommission(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.GeneralProductFop": 
            case "com.gridnine.xtrip.common.model.booking.air.ProductFop": 
            case "com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop": 
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop": {
                this.readProductFop(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.system.Money": {
                this.readMoney(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.system.RateMoney": {
                this.readRateMoney(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.profile.Communication": {
                this.readCommunication(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.profile.Passport": {
                this.readPassport(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.profile.ContractRelationDescription": {
                this.readContractRelationDescription(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.VatDetalization": {
                this.readVendorVatDetalization(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.VatComponent": {
                this.readVatComponent(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference": {
                this.readPassengerTypeReference(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.railway.ReservedSeat": {
                this.readReservedSeat(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference": {
                this.readPassengerTypeReference(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.Room": {
                this.readHotelRoom(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelCommission": {
                this.readHotelCommission(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge": {
                this.readCancellationCharge(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.Meal": {
                this.readHotelMeal(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability": {
                this.readHotelAvailability(reader, orderItem);
                break;
            }
            case "com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService": {
                this.readAdditionalService(reader, orderItem);
            }
        }
    }

    private void readBookingFile(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        BookingFile bookingFile = new BookingFile();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"createDate".equals(reader.getLocalName())) break;
                    bookingFile.setCreateDate(this.dateFormat.parse(this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"bookingFile".equals(reader.getLocalName())) break;
                    orderItem.setBookingFile(bookingFile);
                    return;
                }
            }
        }
    }

    private void readContractRelationDescription(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, EnumUtil.NoSuchEnumValueException {
        String uid = reader.getAttributeValue(1);
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1 || !"predefinedType".equals(reader.getLocalName())) continue;
            EntityContainer description = EntityStorage.get().find(ContractRelationDescriptionIndex.class, ContractRelationDescriptionIndex.Property.predefinedType.name(), (Object)EnumUtil.fromName(PredefinedContractRelationType.class, (String)this.getText(reader)));
            orderItem.getRelationDescriptions().put(uid, (EntityReference<ContractRelationDescription>)description.toReference());
            break;
        }
    }

    private void readPassport(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.PassportWrapper wrapper = new PortbiletOrderItem.PassportWrapper();
        Passport passport = new Passport();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "number": {
                            passport.setNumber(this.getText(reader));
                            break;
                        }
                        case "type": {
                            passport.setType(PassportType.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "firstName": {
                            passport.setFirstName(this.getText(reader));
                            break;
                        }
                        case "secondName": {
                            passport.setSecondName(this.getText(reader));
                            break;
                        }
                        case "middleName": {
                            passport.setMiddleName(this.getText(reader));
                            break;
                        }
                        case "lastName": {
                            passport.setLastName(this.getText(reader));
                            break;
                        }
                        case "gender": {
                            passport.setGender(Gender.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "birthday": {
                            passport.setBirthday(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "birthPlace": {
                            passport.setBirthPlace(this.getText(reader));
                            break;
                        }
                        case "citizenship": {
                            wrapper.setCitizenshipUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "issued": {
                            passport.setIssued(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "issueCity": {
                            passport.setIssueCity(this.getText(reader));
                            break;
                        }
                        case "issueOrganization": {
                            passport.setIssueOrganization(this.getText(reader));
                            break;
                        }
                        case "expired": {
                            passport.setExpired(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "originCountry": {
                            wrapper.setOriginCountryUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "remarks": {
                            passport.setRemarks(this.getText(reader));
                            break;
                        }
                        case "sabreProfilesType": {
                            passport.setSabreProfilesType(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setPassport(passport);
                    orderItem.getPassports().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readVendorVatDetalization(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        PortbiletOrderItem.VendorVatDetalizationWrapper wrapper = new PortbiletOrderItem.VendorVatDetalizationWrapper();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "detalized": {
                            wrapper.setDetalized(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "components": {
                            wrapper.getVatComponentUids().addAll(this.readUids(reader, "components"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getVendorVatDetalizations().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readVatComponent(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, EnumUtil.NoSuchEnumValueException {
        String uid = reader.getAttributeValue(1);
        VatComponent vatComponent = new VatComponent();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    block11 : switch (reader.getLocalName()) {
                        case "sum": {
                            vatComponent.setSum(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "rate": {
                            vatComponent.setRate(Double.valueOf(Double.parseDouble(this.getText(reader))));
                            break;
                        }
                        case "basis": {
                            vatComponent.setBasis(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "basisTypes": {
                            while (reader.hasNext()) {
                                event = reader.next();
                                if (event == 1 && "item".equals(reader.getLocalName())) {
                                    vatComponent.getBasisTypes().add(EnumUtil.fromName(VatBasisType.class, (String)this.getText(reader)));
                                    continue;
                                }
                                if (event != 2 || !"basisTypes".equals(reader.getLocalName())) continue;
                                break block11;
                            }
                            break block0;
                        }
                        case "taxesUids": {
                            while (reader.hasNext()) {
                                event = reader.next();
                                if (event == 1 && "item".equals(reader.getLocalName())) {
                                    vatComponent.getTaxesUids().add(this.getText(reader));
                                    continue;
                                }
                                if (event != 2 || !"taxesUids".equals(reader.getLocalName())) continue;
                                break block11;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getVatComponents().put(uid, vatComponent);
                    return;
                }
            }
        }
    }

    private void readPassengerTypeReference(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.PassengerTypeReferenceWrapper wrapper = new PortbiletOrderItem.PassengerTypeReferenceWrapper();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "traveller": {
                            wrapper.setTravellerUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "travellerUid": {
                            wrapper.setTravellerUid(this.getText(reader));
                            break;
                        }
                        case "passengerType": {
                            wrapper.setPassengerTypeUid(reader.getAttributeValue(1));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getPassengerTypeReferences().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readHotelRoom(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.HotelRoomWrapper wrapper = new PortbiletOrderItem.HotelRoomWrapper();
        Room room = new Room();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    block27 : switch (reader.getLocalName()) {
                        case "roomName": {
                            room.setRoomName(this.getText(reader));
                            break;
                        }
                        case "roomSize": {
                            room.setRoomSize(this.getText(reader));
                            break;
                        }
                        case "numberOfPeople": {
                            room.setNumberOfPeople(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break;
                        }
                        case "checkInDate": {
                            room.setCheckInDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "checkOutDate": {
                            room.setCheckOutDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "checkInTime": {
                            room.setCheckInTime(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break;
                        }
                        case "checkOutTime": {
                            room.setCheckOutTime(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break;
                        }
                        case "standardCheckInTime": {
                            room.setStandardCheckInTime(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break;
                        }
                        case "standardCheckOutTime": {
                            room.setStandardCheckOutTime(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break;
                        }
                        case "vat": {
                            room.setVat(Boolean.valueOf(Boolean.parseBoolean(this.getText(reader))));
                            break;
                        }
                        case "baseRate": {
                            wrapper.setBaseRateUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "basePrice": {
                            wrapper.setBasePriceUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentPrice": {
                            room.setEquivalentPrice(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentRate": {
                            room.setEquivalentRate(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVatPrice": {
                            room.setEquivalentVatPrice(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivVatRate": {
                            room.setEquivVatRate(Double.valueOf(Double.parseDouble(this.getText(reader))));
                            break;
                        }
                        case "meal": {
                            wrapper.setMealUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "rateType": {
                            room.setRateType((RateType)EnumUtil.fromNameSafe(RateType.class, (String)this.getText(reader), (boolean)true));
                            break;
                        }
                        case "availability": {
                            wrapper.setAvailabilityUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "roomTravellersUids": {
                            while (reader.hasNext()) {
                                event = reader.next();
                                if (event == 1 && "item".equals(reader.getLocalName())) {
                                    wrapper.getRoomTravellerUids().add(this.getText(reader));
                                    continue;
                                }
                                if (event != 2 || !"roomTravellersUids".equals(reader.getLocalName())) continue;
                                break block27;
                            }
                            break block0;
                        }
                        case "availableOptions": {
                            wrapper.getAvailableOptionUids().addAll(this.readUids(reader, "availableOptions"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setRoom(room);
                    orderItem.getHotelRooms().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readHotelCommission(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.HotelCommissionWrapper wrapper = new PortbiletOrderItem.HotelCommissionWrapper();
        HotelProductCommission commission = new HotelProductCommission();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "amount": {
                            wrapper.setAmountUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentAmount": {
                            commission.setEquivalentAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setCommission(commission);
                    orderItem.getHotelCommissions().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readCancellationCharge(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.CancellationChargeWrapper wrapper = new PortbiletOrderItem.CancellationChargeWrapper();
        CancellationCharge cancellationCharge = new CancellationCharge();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "startDate": {
                            cancellationCharge.setStartDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "endDate": {
                            cancellationCharge.setEndDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "withTime": {
                            cancellationCharge.setWithTime(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "timeZoneIsUnknown": {
                            cancellationCharge.setTimeZoneIsUnknown(Boolean.valueOf(Boolean.parseBoolean(this.getText(reader))));
                            break;
                        }
                        case "penalty": {
                            wrapper.setPenaltyUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "penaltyEquivalentAmount": {
                            cancellationCharge.setPenaltyEquivalentAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "penaltyEquivalentVatAmount": {
                            cancellationCharge.setPenaltyEquivalentVatAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "penaltyEquivalentVatRate": {
                            cancellationCharge.setPenaltyEquivalentVatRate(Double.valueOf(Double.parseDouble(this.getText(reader))));
                            break;
                        }
                        case "policyText": {
                            cancellationCharge.setPolicyText(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setCancellationCharge(cancellationCharge);
                    orderItem.getCancellationCharges().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readHotelMeal(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        Meal meal = new Meal();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "code": {
                            meal.setCode(this.getText(reader));
                            break;
                        }
                        case "caption": {
                            meal.setCaption(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getHotelMeals().put(uid, meal);
                    return;
                }
            }
        }
    }

    private void readHotelAvailability(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        HotelsServiceAvailability availability = new HotelsServiceAvailability();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "immediateConfirmation": {
                            availability.setImmediateConfirmation(Boolean.valueOf(Boolean.parseBoolean(this.getText(reader))));
                            break;
                        }
                        case "payee": {
                            availability.setPayee(HotelsPayee.valueOf((String)this.getText(reader)));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getHotelsAvailabilities().put(uid, availability);
                    return;
                }
            }
        }
    }

    private void readAdditionalService(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.AdditionalServiceWrapper wrapper = new PortbiletOrderItem.AdditionalServiceWrapper();
        AdditionalService additionalService = new AdditionalService();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "name": {
                            additionalService.setName(this.getText(reader));
                            break;
                        }
                        case "code": {
                            additionalService.setCode(this.getText(reader));
                            break;
                        }
                        case "type": {
                            additionalService.setType(AdditionalServiceType.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "count": {
                            additionalService.setCount(Integer.parseInt(this.getText(reader)));
                            break;
                        }
                        case "baseAmount": {
                            wrapper.setBaseAmountUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentAmount": {
                            additionalService.setEquivalentAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVatAmount": {
                            additionalService.setEquivalentVatAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVatRate": {
                            additionalService.setEquivalentVatRate(Double.valueOf(Double.parseDouble(this.getText(reader))));
                            break;
                        }
                        case "includedInTariff": {
                            additionalService.setIncludedInTariff(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setAdditionalService(additionalService);
                    orderItem.getAdditionalServices().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readReservedSeat(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.ReservedSeatWrapper wrapper = new PortbiletOrderItem.ReservedSeatWrapper();
        ReservedSeat reservedSeat = new ReservedSeat();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "fare": {
                            wrapper.setFareUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "segment": {
                            wrapper.setSegmentUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentFare": {
                            reservedSeat.setEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVAT": {
                            reservedSeat.setEquivalentVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentDeduction": {
                            reservedSeat.setEquivalentDeduction(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentDeductionVAT": {
                            reservedSeat.setEquivalentDeductionVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "scn": {
                            reservedSeat.setScn(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setReservedSeat(reservedSeat);
                    orderItem.getReservedSeats().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readCommunication(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        Communication communication = new Communication();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "type": {
                            communication.setType(CommunicationType.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "sense": {
                            communication.setSense(this.getText(reader));
                            break;
                        }
                        case "countryCode": {
                            communication.setCountryCode(this.getText(reader));
                            break;
                        }
                        case "cityCode": {
                            communication.setCityCode(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getCommunication().put(uid, communication);
                    return;
                }
            }
        }
    }

    private void readMoney(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        Money money = new Money();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "value": {
                            money.setValue(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "currency": {
                            money.setCurrency(this.getText(reader));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getMoney().put(uid, money);
                    return;
                }
            }
        }
    }

    private void readRateMoney(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.RateMoneyWrapper wrapper = new PortbiletOrderItem.RateMoneyWrapper();
        RateMoney rateMoney = new RateMoney();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "rate": {
                            rateMoney.setRate(Double.valueOf(Double.parseDouble(this.getText(reader))));
                            break;
                        }
                        case "money": {
                            wrapper.setMoneyUid(reader.getAttributeValue(1));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setRateMoney(rateMoney);
                    orderItem.getRateMoney().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readProductCommission(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.ProductCommissionWrapper wrapper = new PortbiletOrderItem.ProductCommissionWrapper();
        GeneralProductCommission productCommission = new GeneralProductCommission();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "rate": {
                            productCommission.setRate(Double.valueOf(this.getText(reader)));
                            break;
                        }
                        case "amount": {
                            wrapper.setAmountUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentAmount": {
                            productCommission.setEquivalentAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "commissionProperties": {
                            wrapper.setCommissionPropertiesType(reader.getAttributeValue(null, "type"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setProductCommission(productCommission);
                    orderItem.getProductCommissions().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readProductFop(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        ProductFop productFop = new ProductFop();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"type".equals(reader.getLocalName())) break;
                    productFop.setType(PaymentType.valueOf((String)this.getText(reader)));
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getProductFops().put(uid, productFop);
                    return;
                }
            }
        }
    }

    private void readProductContractRelationData(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.ContractRelationWrapper wrapper = new PortbiletOrderItem.ContractRelationWrapper();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "description": {
                            wrapper.setDescriptionUid(reader.getAttributeValue(2));
                            break;
                        }
                        case "commissions": {
                            wrapper.getProductCommissionUids().addAll(this.readUids(reader, "commissions"));
                            break;
                        }
                        case "fops": {
                            wrapper.getProductFopUids().addAll(this.readUids(reader, "fops"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getContractRelationData().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readPerson(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        Person person = new Person();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"loginName".equals(reader.getLocalName())) break;
                    person.setLoginName(this.getText(reader));
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.getPersons().put(uid, person);
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readTraveller(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.TravelerWrapper wrapper = new PortbiletOrderItem.TravelerWrapper();
        Traveller traveller = new Traveller();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "name": {
                            traveller.setName(this.getText(reader));
                            break block0;
                        }
                        case "cyrillicName": {
                            traveller.setCyrillicName(this.getText(reader));
                            break block0;
                        }
                        case "gender": {
                            traveller.setGender(Gender.valueOf((String)this.getText(reader)));
                            break block0;
                        }
                        case "birthday": {
                            traveller.setBirthday(this.dateFormat.parse(this.getText(reader)));
                            break block0;
                        }
                        case "passenger": {
                            wrapper.setPassengerUid(reader.getAttributeValue(2));
                            break block0;
                        }
                        case "passport": {
                            wrapper.setPassportUid(reader.getAttributeValue(1));
                            break block0;
                        }
                        case "communications": {
                            wrapper.getCommunicationUids().addAll(this.readUids(reader, "communications"));
                            break block0;
                        }
                    }
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setTraveller(traveller);
                    orderItem.getTravellers().put(uid, wrapper);
                    return;
                }
            }
        }
        return;
    }

    private void readTax(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.AirTaxWrapper wrapper = new PortbiletOrderItem.AirTaxWrapper();
        Tax tax = new Tax();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "amount": {
                            wrapper.setAmountUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentAmount": {
                            tax.setEquivalentAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "code": {
                            tax.setCode(this.getText(reader));
                            break;
                        }
                        case "segmentTariff": {
                            wrapper.setSegmentTariffUid(reader.getAttributeValue(1));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setTax(tax);
                    orderItem.getAirTaxes().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readLuggageInfo(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.AirLuggageInfoWrapper wrapper = new PortbiletOrderItem.AirLuggageInfoWrapper();
        LuggageInfo luggageInfo = new LuggageInfo();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "nil": {
                            luggageInfo.setNil(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "quantity": {
                            luggageInfo.setQuantity(Integer.valueOf(this.getText(reader)));
                            break;
                        }
                        case "unit": {
                            wrapper.setLuggageUnitUid(reader.getAttributeValue(1));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setLuggageInfo(luggageInfo);
                    orderItem.getLuggageInfos().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readRailwayTax(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.RailwayTaxWrapper wrapper = new PortbiletOrderItem.RailwayTaxWrapper();
        RailwayTax tax = new RailwayTax();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "fare": {
                            wrapper.setFareUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentFare": {
                            tax.setEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVAT": {
                            tax.setEquivalentVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "code": {
                            tax.setCode(this.getText(reader));
                            break;
                        }
                        case "segment": {
                            wrapper.setSegmentUid(reader.getAttributeValue(1));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setTax(tax);
                    orderItem.getRailwayTaxes().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readProductFare(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.ProductFareWrapper wrapper = new PortbiletOrderItem.ProductFareWrapper();
        ProductFare productFare = new ProductFare();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "segmentTariff": {
                            wrapper.setSegmentTariffUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "nucFare": {
                            productFare.setNucFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "baseFare": {
                            wrapper.setAmountUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "equivalentFare": {
                            productFare.setEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setProductFare(productFare);
                    orderItem.getProductFares().put(uid, wrapper);
                    return;
                }
            }
        }
    }

    private void readSegmentTariff(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        PortbiletOrderItem.SegmentTariffWrapper segmentTariffWrapper = new PortbiletOrderItem.SegmentTariffWrapper();
        segmentTariffWrapper.setUid(reader.getAttributeValue(1).trim());
        segmentTariffWrapper.getSegmentUids().addAll(this.readUids(reader, "segments"));
        orderItem.getSegmentTariffWrapper().add(segmentTariffWrapper);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readSegment(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1).trim();
        PortbiletOrderItem.SegmentWrapper wrapper = new PortbiletOrderItem.SegmentWrapper();
        Segment segment = new Segment();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "recordNumber": {
                            segment.setRecordNumber(Integer.parseInt(this.getText(reader)));
                            break block0;
                        }
                        case "startDate": {
                            segment.setStartDate(this.dateFormat.parse(this.getText(reader)));
                            break block0;
                        }
                        case "endDate": {
                            segment.setEndDate(this.dateFormat.parse(this.getText(reader)));
                            break block0;
                        }
                        case "flightNo": {
                            segment.setFlightNo(this.getText(reader));
                            break block0;
                        }
                        case "arriveLocation": {
                            wrapper.setArriveLocationUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "departureLocation": {
                            wrapper.setDepartureLocationUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "airline": {
                            wrapper.setAirlineUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "board": {
                            wrapper.setAircraftUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "codeShareCarrier": {
                            wrapper.setCodeShareCarrierUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "serviceClass": {
                            segment.setServiceClass(ClassOfService.valueOf((String)this.getText(reader)));
                            break block0;
                        }
                        case "departTerminal": {
                            segment.setDepartTerminal(this.getText(reader));
                            break block0;
                        }
                        case "fareBasis": {
                            segment.setFareBasis(this.getText(reader));
                            break block0;
                        }
                        case "classOfSvcCode": {
                            segment.setClassOfSvcCode(this.getText(reader));
                            break block0;
                        }
                        case "luggageInfo": {
                            wrapper.setLuggageInfoUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "airlineLocator": {
                            segment.setAirlineLocator(this.getText(reader));
                            break block0;
                        }
                    }
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setSegment(segment);
                    orderItem.getSegments().put(uid, wrapper);
                    return;
                }
            }
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readRailwaySegment(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        String uid = reader.getAttributeValue(1).trim();
        PortbiletOrderItem.RailwaySegmentWrapper wrapper = new PortbiletOrderItem.RailwaySegmentWrapper();
        RailwaySegment segment = new RailwaySegment();
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "number": {
                            segment.setNumber(Integer.parseInt(this.getText(reader)));
                            break block0;
                        }
                        case "carriageNumber": {
                            segment.setCarriageNumber(this.getText(reader));
                            break block0;
                        }
                        case "carriageType": {
                            segment.setCarriageType(CarriageType.valueOf((String)this.getText(reader)));
                            break block0;
                        }
                        case "serviceClass": {
                            segment.setServiceClass(ServiceClass.valueOf((String)this.getText(reader)));
                            break block0;
                        }
                        case "trainNumber": {
                            segment.setTrainNumber(this.getText(reader));
                            break block0;
                        }
                        case "departureDate": {
                            segment.setDepartureDate(this.dateFormat.parse(this.getText(reader)));
                            break block0;
                        }
                        case "arriveDate": {
                            segment.setArriveDate(this.dateFormat.parse(this.getText(reader)));
                            break block0;
                        }
                        case "departureStation": {
                            wrapper.setDepartureStationUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "arriveStation": {
                            wrapper.setArriveStationUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "fare": {
                            wrapper.setFareUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "equivalentFare": {
                            segment.setEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break block0;
                        }
                        case "equivalentVAT": {
                            segment.setEquivalentVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break block0;
                        }
                        case "eRegEnabled": {
                            segment.setERegEnabled(Boolean.parseBoolean(this.getText(reader)));
                            break block0;
                        }
                        case "hasEReg": {
                            segment.setHasEReg(Boolean.parseBoolean(this.getText(reader)));
                            break block0;
                        }
                        case "route": {
                            wrapper.setRouteUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "carrier": {
                            wrapper.setCarrierUid(reader.getAttributeValue(1).trim());
                            break block0;
                        }
                        case "addInfo": {
                            segment.setAddInfo(this.getText(reader));
                            break block0;
                        }
                        case "durationInMinutes": {
                            segment.setDurationInMinutes(Integer.valueOf(Integer.parseInt(this.getText(reader))));
                            break block0;
                        }
                        case "trainCategory": {
                            segment.setTrainCategory(this.getText(reader));
                            break block0;
                        }
                        case "international": {
                            segment.setInternational(Boolean.valueOf(Boolean.parseBoolean(this.getText(reader))));
                            break block0;
                        }
                        case "arrivalLocation": {
                            segment.setArrivalLocation(this.getText(reader));
                            break block0;
                        }
                        case "departureLocation": {
                            segment.setDepartureLocation(this.getText(reader));
                            break block0;
                        }
                        case "carrierRoute": {
                            segment.setCarrierRoute(this.getText(reader));
                            break block0;
                        }
                        case "carrierSubcategory": {
                            segment.setCarrierSubcategory(this.getText(reader));
                            break block0;
                        }
                        case "carriageTypeTitle": {
                            segment.setCarriageTypeTitle(this.getText(reader));
                            break block0;
                        }
                        case "serviceDescription": {
                            segment.setServiceDescription(this.getText(reader));
                            break block0;
                        }
                        case "serviceList": {
                            segment.setServiceList(this.getText(reader));
                            break block0;
                        }
                    }
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setSegment(segment);
                    orderItem.getRailwaySegments().put(uid, wrapper);
                    return;
                }
            }
        }
        return;
    }

    private void readGeoLocation(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, EnumUtil.NoSuchEnumValueException {
        String uid = reader.getAttributeValue(1).trim();
        HashMap<CodeSystem, String> codesMap = new HashMap<CodeSystem, String>();
        LocationType locationType = null;
        while (reader.hasNext()) {
            block17: {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        block8 : switch (reader.getLocalName()) {
                            case "codeVariants": {
                                while (reader.hasNext()) {
                                    event = reader.next();
                                    if (event == 1 && "item".equals(reader.getLocalName())) {
                                        CodeSystem codeSystem = (CodeSystem)EnumUtil.fromNameSafe(CodeSystem.class, (String)reader.getAttributeValue(null, "codeSystem"), (boolean)false);
                                        if (codeSystem == null) continue;
                                        codesMap.put(codeSystem, this.getText(reader));
                                        continue;
                                    }
                                    if (event != 2 || !"codeVariants".equals(reader.getLocalName())) continue;
                                    break block8;
                                }
                                break block17;
                            }
                            case "type": {
                                locationType = (LocationType)EnumUtil.fromName(LocationType.class, (String)this.getText(reader));
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (!"dictionary".equals(reader.getLocalName())) break;
                        GeoLocation geoLocation = DictHelper.findGeoLocationByCodeVariant((String)((String)codesMap.get(CodeSystem.IATA)), (CodeSystem)CodeSystem.IATA, locationType);
                        if (geoLocation != null) {
                            orderItem.getGeoLocations().put(uid, (DictionaryReference<GeoLocation>)geoLocation.toReference());
                            return;
                        }
                        geoLocation = DictHelper.findGeoLocationByCodeVariant((String)((String)codesMap.get(CodeSystem.CRT)), (CodeSystem)CodeSystem.CRT, (LocationType)locationType);
                        if (geoLocation != null) {
                            orderItem.getGeoLocations().put(uid, (DictionaryReference<GeoLocation>)geoLocation.toReference());
                        }
                        return;
                    }
                }
            }
        }
    }

    private void readOrganization(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        String uid = reader.getAttributeValue(1).trim();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"code".equals(reader.getLocalName())) break;
                    orderItem.getOrganizations().put(uid, (EntityReference<Organization>)ProfileHelper.findOrganizationRef((String)this.getText(reader)));
                    return;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void readCustomer(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException {
        Customer customer = new Customer();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"name".equals(reader.getLocalName())) break;
                    customer.setName(this.getText(reader));
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    orderItem.setCustomer(customer);
                    return;
                }
            }
        }
    }

    private void readReservation(XMLStreamReader reader, PortbiletOrderItem orderItem) throws XMLStreamException, ParseException {
        PortbiletOrderItem.ReservationWrapper wrapper = new PortbiletOrderItem.ReservationWrapper();
        Reservation reservation = new Reservation();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "recordLocator": {
                            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.PORTBILET, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)this.getText(reader));
                            break;
                        }
                        case "pricingDate": {
                            reservation.setPricingDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "resDate": {
                            reservation.setResDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "timeLimit": {
                            reservation.setTimeLimit(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "bookingAgent": {
                            wrapper.setBookingAgent(reader.getAttributeValue(2).trim());
                            break;
                        }
                        case "products": {
                            wrapper.getProductUids().addAll(this.readUids(reader, "products"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    wrapper.setReservation(reservation);
                    orderItem.getReservations().add(wrapper);
                    return;
                }
            }
        }
    }

    private void readProduct(XMLStreamReader reader, PortbiletOrderItem orderItem, String className) throws XMLStreamException, ParseException, EnumUtil.NoSuchEnumValueException {
        String uid = reader.getAttributeValue(1);
        PortbiletOrderItem.ProductWrapper productWrapper = new PortbiletOrderItem.ProductWrapper();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    block77 : switch (reader.getLocalName()) {
                        case "status": {
                            productWrapper.setStatus((ProductStatus)EnumUtil.fromName(ProductStatus.class, (String)this.getText(reader)));
                            break;
                        }
                        case "systemNumber": {
                            productWrapper.setSystemNumber(this.getText(reader));
                            break;
                        }
                        case "productCategory": {
                            productWrapper.setProductCategory((ProductCategory)EnumUtil.fromName(ProductCategory.class, (String)this.getText(reader)));
                            break;
                        }
                        case "mcoCategory": {
                            productWrapper.setMcoCategory(this.getText(reader));
                            break;
                        }
                        case "provider": {
                            switch (className) {
                                case "com.gridnine.xtrip.common.model.booking.railway.RailwayProduct": 
                                case "com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct": {
                                    productWrapper.setProviderUid(reader.getAttributeValue(2).trim());
                                    break block77;
                                }
                                case "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct": {
                                    productWrapper.setHotelProvider(HotelProvider.valueOf((String)this.getText(reader)));
                                    break block77;
                                }
                            }
                        }
                        case "providerSystemNumber": {
                            productWrapper.setProviderSystemNumber(this.getText(reader));
                            break;
                        }
                        case "blankOwnerRef": {
                            productWrapper.setBlankOwnerRefUid(reader.getAttributeValue(2).trim());
                            break;
                        }
                        case "blankOwnerNumber": {
                            productWrapper.setBlankOwnerNumber(this.getText(reader));
                            break;
                        }
                        case "blankOwnerCode": {
                            productWrapper.setBlankOwnerCode(this.getText(reader));
                            break;
                        }
                        case "blankType": {
                            productWrapper.setBlankTypeUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "carrier": {
                            productWrapper.setCarrierUid(reader.getAttributeValue(1).trim());
                            break;
                        }
                        case "carrierNumber": {
                            productWrapper.setCarrierNumber(this.getText(reader));
                            break;
                        }
                        case "ticketType": {
                            productWrapper.setTicketType(TicketType.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "vendorVatDetalization": {
                            productWrapper.setVendorVatDetalizationUid(reader.getAttributeValue(1).trim());
                            break;
                        }
                        case "gdsCurrency": {
                            productWrapper.setGdsCurrency(this.getText(reader));
                            break;
                        }
                        case "totalVendorEquivalentVatAmount": {
                            productWrapper.setTotalVendorEquivalentVatAmount(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "traveller": {
                            productWrapper.setTravellerUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "tariffType": {
                            productWrapper.setTariffType(TariffType.valueOf((String)this.getText(reader)));
                            break;
                        }
                        case "issueDate": {
                            productWrapper.setIssueDate(ParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.dateFormat, (String)this.getText(reader)));
                            break;
                        }
                        case "validatorCode": {
                            productWrapper.setValidatorCode(this.getText(reader));
                            break;
                        }
                        case "pcc": {
                            productWrapper.setPcc(this.getText(reader));
                            break;
                        }
                        case "conjCount": {
                            productWrapper.setConjCount(Integer.parseInt(this.getText(reader)));
                            break;
                        }
                        case "addCollectBase": {
                            productWrapper.setAddCollectBase(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "penalty": {
                            productWrapper.setPenalty(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "addCollectEquivalent": {
                            productWrapper.setAddCollectEquivalent(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentFare": {
                            productWrapper.setEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "equivalentVat": {
                            productWrapper.setEquivalentVat(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "penaltyFare": {
                            productWrapper.setPenaltyare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "penaltyVat": {
                            productWrapper.setPenaltyVat(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "serviceFare": {
                            productWrapper.setServiceFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "serviceVAT": {
                            productWrapper.setServiceVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "totalEquivalentFare": {
                            productWrapper.setTotalEquivalentFare(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "totalEquivalentVAT": {
                            productWrapper.setTotalEquivalentVAT(new BigDecimal(this.getText(reader)).setScale(2, RoundingMode.HALF_UP));
                            break;
                        }
                        case "refundExpireDate": {
                            productWrapper.setRefundExpireDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "ERegExpireDate": {
                            productWrapper.setERegExpireDate(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "rzdStatus": {
                            productWrapper.setRzdStatus((RzdStatus)EnumUtil.fromNameSafe(RzdStatus.class, (String)this.getText(reader), (boolean)true));
                            break;
                        }
                        case "blankId": {
                            productWrapper.setBlankId(this.getText(reader));
                            break;
                        }
                        case "endorsement": {
                            productWrapper.setEndorsement(this.getText(reader));
                            break;
                        }
                        case "fareCalculationData": {
                            productWrapper.setFareCalculationData(this.getText(reader));
                            break;
                        }
                        case "tariff": {
                            productWrapper.setTariff((RzdTariff)EnumUtil.fromNameSafe(RzdTariff.class, (String)this.getText(reader), (boolean)true));
                            break;
                        }
                        case "hotelCommission": {
                            productWrapper.setHotelCommissionUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "options": {
                            productWrapper.setHotelOptionsUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "hotelStars": {
                            productWrapper.setHotelStars(Integer.parseInt(this.getText(reader)));
                            break;
                        }
                        case "hotelAddress": {
                            productWrapper.setHotelAddress(this.getText(reader));
                            break;
                        }
                        case "hotelPhone": {
                            productWrapper.setHotelPhone(this.getText(reader));
                            break;
                        }
                        case "hotelFax": {
                            productWrapper.setHotelFax(this.getText(reader));
                            break;
                        }
                        case "freeCancellationTerm": {
                            productWrapper.setFreeCancellationTerm(this.dateFormat.parse(this.getText(reader)));
                            break;
                        }
                        case "cancellable": {
                            productWrapper.setCancellable(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "cancellableNow": {
                            productWrapper.setCancellableNow(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "hotelLocation": {
                            productWrapper.setHotelLocationUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "hotelName": {
                            productWrapper.setHotelName(this.getText(reader));
                            break;
                        }
                        case "hotelCountry": {
                            productWrapper.setHotelCountryUid(reader.getAttributeValue(1));
                            break;
                        }
                        case "cotsGuaranteed": {
                            productWrapper.setCotsGuaranteed(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "waitingForRefundConfirmation": {
                            productWrapper.setWaitingForRefundConfirmation(Boolean.parseBoolean(this.getText(reader)));
                            break;
                        }
                        case "passengers": {
                            productWrapper.getPassengerUids().addAll(this.readUids(reader, "passengers"));
                            break;
                        }
                        case "passengerTypes": {
                            productWrapper.getPassengerTypeUids().addAll(this.readUids(reader, "passengerTypes"));
                            break;
                        }
                        case "segments": {
                            productWrapper.getSegmentUids().addAll(this.readUids(reader, "segments"));
                            break;
                        }
                        case "passengerType": {
                            productWrapper.setPassengerTypeUid(reader.getAttributeValue(1).trim());
                            break;
                        }
                        case "previousProduct": {
                            productWrapper.setPreviousProductUid(reader.getAttributeValue(1).trim());
                            break;
                        }
                        case "nextProduct": {
                            productWrapper.setNextProductUid(reader.getAttributeValue(1).trim());
                            break;
                        }
                        case "segmentTariffs": {
                            productWrapper.getSegmentTariffUids().addAll(this.readUids(reader, "segmentTariffs"));
                            break;
                        }
                        case "contractRelations": {
                            productWrapper.getContractRelationUids().addAll(this.readUids(reader, "contractRelations"));
                            break;
                        }
                        case "fares": {
                            productWrapper.getFareUids().addAll(this.readUids(reader, "fares"));
                            break;
                        }
                        case "taxes": {
                            productWrapper.getTaxUids().addAll(this.readUids(reader, "taxes"));
                            break;
                        }
                        case "relatedProducts": {
                            productWrapper.getRelatedProductUids().addAll(this.readUids(reader, "relatedProducts"));
                            break;
                        }
                        case "reservedSeats": {
                            productWrapper.getReservedSeatUids().addAll(this.readUids(reader, "reservedSeats"));
                            break;
                        }
                        case "rooms": {
                            productWrapper.getRoomUids().addAll(this.readUids(reader, "rooms"));
                            break;
                        }
                        case "travellers": {
                            productWrapper.getTravellerUids().addAll(this.readUids(reader, "travellers"));
                            break;
                        }
                        case "travellersPassengerTypes": {
                            productWrapper.getTravellersPassengerTypeUids().addAll(this.readUids(reader, "travellersPassengerTypes"));
                            break;
                        }
                        case "cancellationCharges": {
                            productWrapper.getCancellationChargeUids().addAll(this.readUids(reader, "cancellationCharges"));
                            break;
                        }
                        case "additionalServices": {
                            productWrapper.getAdditionalServiceUids().addAll(this.readUids(reader, "additionalServices"));
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"entity".equals(reader.getLocalName())) break;
                    productWrapper.setClassName(className);
                    orderItem.getProducts().put(uid, productWrapper);
                    return;
                }
            }
        }
    }

    private List<String> readUids(XMLStreamReader reader, String tagName) throws XMLStreamException {
        ArrayList<String> result = new ArrayList<String>();
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1 && "item".equals(reader.getLocalName())) {
                result.add(reader.getAttributeValue(1).trim());
                continue;
            }
            if (event != 2 || !tagName.equals(reader.getLocalName())) continue;
            break;
        }
        return result;
    }

    private String getText(XMLStreamReader reader) throws XMLStreamException {
        return reader.getElementText().trim();
    }
}

