/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class PortbiletFindOrCreateBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        if (orderItem.getReservations().stream().anyMatch(r -> {
            String pnr = CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)r.getReservation(), (GdsName)GdsName.PORTBILET, (RecordLocatorType)RecordLocatorType.DEFAULT);
            List<String> systemNumbers = orderItem.getProducts().values().stream().map(PortbiletOrderItem.ProductWrapper::getSystemNumber).collect(Collectors.toList());
            Date creationDate = r.getReservation().getResDate();
            if (TextUtil.isBlank((String)pnr)) {
                throw Xeption.forEndUser((String)"\u0412 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 PNR", (Object[])new Object[0]);
            }
            if (creationDate == null && !r.getReservation().getProducts().stream().allMatch(product -> ProductHandler.of((BaseProduct)product).getStatus(product) == ProductStatus.VOID_BOOKING)) {
                throw Xeption.forEndUser((String)"\u0412 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
            }
            return PortbiletFindOrCreateBookingProcessor.findBookingByPnrAndSystemNumbers(pnr, systemNumbers, creationDate, ctx);
        })) {
            return;
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)EntityContainer.create((BaseEntity)new BookingFile()));
    }

    private static boolean findBookingByPnrAndSystemNumbers(String pnr, List<String> systemNumbers, Date creationDate, MessageContext ctx) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(CommonProductIndex.Property.issueDate.name());
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForCommonProductIndex((String)pnr));
        Date lowerBound = null;
        if (creationDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(creationDate);
            cal.add(1, -2);
            lowerBound = cal.getTime();
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)lowerBound));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (Object item : EntityStorage.get().search(CommonProductIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        EntityContainer result = null;
        if (bookings.size() == 1) {
            result = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else if (bookings.size() > 1) {
            for (EntityReference entityReference : bookings) {
                boolean containsSameProducts;
                EntityContainer bookingCtr = EntityStorage.get().resolve(entityReference);
                if (bookingCtr == null || !(containsSameProducts = BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity())).stream().anyMatch(product -> CollectionUtil.containAtLeastOneCommonElement((Collection)systemNumbers, (Collection)ProductHandler.of((BaseProduct)product).getProductNumbers(product))))) continue;
                if (result == null) {
                    result = bookingCtr;
                    continue;
                }
                throw Xeption.forEndUser((String)"\u0414\u043b\u044f pnr {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}", (Object[])new Object[]{pnr, lowerBound});
            }
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(CommonProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForCommonProductIndex((String)pnr));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (ArchivedProductIndex item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (archivedBookings.isEmpty()) {
                return false;
            }
            HashSet<EntityReference> hashSet = new HashSet<EntityReference>();
            for (EntityReference item : archivedBookings) {
                if (item.getType().equals(BookingFile.class)) continue;
                EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
                    if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)pnr, (GdsName)GdsName.PORTBILET) || res.getResDate() != null && !res.getResDate().after(lowerBound)) continue;
                    hashSet.add(item);
                }
            }
            if (hashSet.isEmpty()) {
                return false;
            }
            if (hashSet.size() > 1) {
                throw Xeption.forEndUser((String)"\u0414\u043b\u044f pnr {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}", (Object[])new Object[]{pnr, lowerBound});
            }
            result = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)hashSet.iterator().next()));
            if (result != null) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{result.toReference()}));
            }
        }
        if (result != null) {
            ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)result);
            for (Reservation reservation : ((BookingFile)result.getEntity()).getReservations()) {
                if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)GdsName.PORTBILET)) continue;
                ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)reservation);
                ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
                return true;
            }
            throw Xeption.forDeveloper((String)"internal error: product found but PNR absent, booking = {0} pnr = {1}", (Object[])new Object[]{result.toReference(), pnr});
        }
        return false;
    }
}

