/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.Map;
import java.util.Set;

public class PortbiletFindOrCreateProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Map products = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCTS);
        Set newProductUids = (Set)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.NEW_PRODUCT_UIDS);
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        for (Map.Entry<String, PortbiletOrderItem.ProductWrapper> entry : orderItem.getProducts().entrySet()) {
            BaseProduct product;
            PortbiletOrderItem.ProductWrapper productWrapper = entry.getValue();
            if (productWrapper.getStatus() == ProductStatus.BOOKING || productWrapper.getStatus() == ProductStatus.VOID_BOOKING) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"PortbiletParser_ignoredProductStatusPresent", (Object[])new Object[]{productWrapper.getStatus()}));
                continue;
            }
            BaseProduct wrapperProduct = (BaseProduct)Class.forName(productWrapper.getClassName()).newInstance();
            if (wrapperProduct instanceof Product) {
                ((Product)wrapperProduct).setProductCategory(productWrapper.getProductCategory());
                ((Product)wrapperProduct).setMcoCategory((MCOCategory)EnumUtil.fromNameSafe(MCOCategory.class, (String)productWrapper.getMcoCategory(), (boolean)true));
            }
            if ((product = BookingHelper.findProduct((BookingFile)bookingFile, (ProductType)BookingHelper.getProductType((BaseProduct)wrapperProduct), (ProductStatus)productWrapper.getStatus(), (String)productWrapper.getSystemNumber())) == null && (productWrapper.getStatus() == ProductStatus.VOID || productWrapper.getStatus() == ProductStatus.REJECT)) {
                product = BookingHelper.findProduct((BookingFile)bookingFile, (ProductType)BookingHelper.getProductType((BaseProduct)wrapperProduct), (ProductStatus)ProductStatus.SELL, (String)productWrapper.getSystemNumber());
            }
            if (product == null) {
                newProductUids.add(entry.getKey());
                product = wrapperProduct;
            }
            products.put(entry.getKey(), product);
        }
    }
}

