/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PortbiletParseTravellersProcessor
extends BaseProcessor {
    private static final String PASSPORT_REGEX = "[^a-zA-Z\u0430-\u044f\u0410-\u042f0-9]";

    public void process(MessageContext ctx) {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (Map.Entry<String, PortbiletOrderItem.TravelerWrapper> entry : orderItem.getTravellers().entrySet()) {
            PortbiletOrderItem.TravelerWrapper travelerWrapper = entry.getValue();
            Traveller traveller = travelerWrapper.getTraveller();
            for (String uid : travelerWrapper.getCommunicationUids()) {
                traveller.getCommunications().add(orderItem.getCommunication().get(uid));
            }
            PortbiletOrderItem.PassportWrapper passportWrapper = orderItem.getPassports().get(travelerWrapper.getPassportUid());
            Passport passport = passportWrapper.getPassport();
            passport.setCitizenship(orderItem.getCountries().get(passportWrapper.getCitizenshipUid()));
            passport.setOriginCountry(orderItem.getCountries().get(passportWrapper.getOriginCountryUid()));
            traveller.setPassport(passport);
            traveller.setPassenger(ProfileHelper.findPerson((Traveller)traveller, null));
        }
        ctx.putObject((Enum)IbusPortbiletParserContextKeys.TRAVELLERS, this.mergeTravellers(orderItem.getTravellers(), (BookingFile)bookingFile.getEntity()));
    }

    private Map<String, Traveller> mergeTravellers(Map<String, PortbiletOrderItem.TravelerWrapper> travellers, BookingFile bookingFile) {
        Object resultTraveller;
        HashMap travellersToMerge = new HashMap();
        HashMap<String, Traveller> result = new HashMap<String, Traveller>();
        for (Map.Entry<String, PortbiletOrderItem.TravelerWrapper> entry : travellers.entrySet()) {
            List samePassengers = travellers.values().stream().filter(travelerWrapper -> TextUtil.nonBlank((String)travelerWrapper.getPassengerUid())).filter(travelerWrapper -> travelerWrapper.getPassengerUid().equals(((PortbiletOrderItem.TravelerWrapper)entry.getValue()).getPassengerUid())).map(PortbiletOrderItem.TravelerWrapper::getTraveller).collect(Collectors.toList());
            if (samePassengers.size() > 1) {
                travellersToMerge.put(entry.getKey(), samePassengers);
                continue;
            }
            Traveller traveller = entry.getValue().getTraveller();
            resultTraveller = PortbiletParseTravellersProcessor.findTraveller(traveller, bookingFile);
            if (resultTraveller != null) {
                this.fillTraveller((Traveller)resultTraveller, traveller);
            } else {
                resultTraveller = traveller;
            }
            result.put(entry.getKey(), (Traveller)resultTraveller);
        }
        HashMap<String, Traveller> mergedTravellers = new HashMap<String, Traveller>();
        block1: for (Map.Entry entry : travellersToMerge.entrySet()) {
            Traveller mergedTraveller = new Traveller();
            for (Traveller traveller : (List)entry.getValue()) {
                if (mergedTravellers.get(traveller.getUid()) != null) {
                    result.put((String)entry.getKey(), (Traveller)mergedTravellers.get(traveller.getUid()));
                    continue block1;
                }
                this.fillTraveller(mergedTraveller, traveller);
            }
            for (Traveller traveller : (List)entry.getValue()) {
                mergedTravellers.put(traveller.getUid(), mergedTraveller);
            }
            resultTraveller = PortbiletParseTravellersProcessor.findTraveller(mergedTraveller, bookingFile);
            if (resultTraveller != null) {
                this.fillTraveller((Traveller)resultTraveller, mergedTraveller);
            } else {
                resultTraveller = mergedTraveller;
            }
            result.put((String)entry.getKey(), (Traveller)resultTraveller);
        }
        return result;
    }

    private void fillTraveller(Traveller toTraveller, Traveller fromTraveller) {
        this.setName(arg_0 -> ((Traveller)toTraveller).setName(arg_0), () -> ((Traveller)toTraveller).getName(), () -> ((Traveller)fromTraveller).getName());
        this.setName(arg_0 -> ((Traveller)toTraveller).setCyrillicName(arg_0), () -> ((Traveller)toTraveller).getCyrillicName(), () -> ((Traveller)fromTraveller).getCyrillicName());
        this.set(arg_0 -> ((Traveller)toTraveller).setGender(arg_0), () -> ((Traveller)fromTraveller).getGender());
        this.set(arg_0 -> ((Traveller)toTraveller).setBirthday(arg_0), () -> ((Traveller)fromTraveller).getBirthday());
        this.set(arg_0 -> ((Traveller)toTraveller).setPassenger(arg_0), () -> ((Traveller)fromTraveller).getPassenger());
        this.set(arg_0 -> ((Traveller)toTraveller).setPassport(arg_0), () -> ((Traveller)fromTraveller).getPassport());
        this.set(arg_0 -> ((Traveller)toTraveller).setGender(arg_0), () -> ((Traveller)fromTraveller).getGender());
        this.mergePassports(toTraveller.getPassport(), fromTraveller.getPassport());
        fromTraveller.getCommunications().stream().filter(communication -> toTraveller.getCommunications().stream().noneMatch(comm -> comm.getType() == communication.getType())).forEach(communication -> this.set(toTraveller.getCommunications()::add, () -> communication));
    }

    private void mergePassports(Passport mergedTravellerPassport, Passport travellerPassport) {
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setNumber(arg_0), () -> ((Passport)travellerPassport).getNumber());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setType(arg_0), () -> ((Passport)travellerPassport).getType());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setFirstName(arg_0), () -> ((Passport)travellerPassport).getFirstName());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setSecondName(arg_0), () -> ((Passport)travellerPassport).getSecondName());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setLastName(arg_0), () -> ((Passport)travellerPassport).getLastName());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setMiddleName(arg_0), () -> ((Passport)travellerPassport).getMiddleName());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setGender(arg_0), () -> ((Passport)travellerPassport).getGender());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setBirthday(arg_0), () -> ((Passport)travellerPassport).getBirthday());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setBirthPlace(arg_0), () -> ((Passport)travellerPassport).getBirthPlace());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setCitizenship(arg_0), () -> ((Passport)travellerPassport).getCitizenship());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setIssued(arg_0), () -> ((Passport)travellerPassport).getIssued());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setIssueCity(arg_0), () -> ((Passport)travellerPassport).getIssueCity());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setIssueOrganization(arg_0), () -> ((Passport)travellerPassport).getIssueOrganization());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setExpired(arg_0), () -> ((Passport)travellerPassport).getExpired());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setOriginCountry(arg_0), () -> ((Passport)travellerPassport).getOriginCountry());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setRemarks(arg_0), () -> ((Passport)travellerPassport).getRemarks());
        this.set(arg_0 -> ((Passport)mergedTravellerPassport).setSabreProfilesType(arg_0), () -> ((Passport)travellerPassport).getSabreProfilesType());
    }

    private static Traveller findTraveller(Traveller traveller, BookingFile bookingFile) {
        if (traveller == null) {
            return null;
        }
        for (Traveller trav : bookingFile.getTravellers()) {
            Boolean sameBirthday;
            if (PortbiletParseTravellersProcessor.samePassport(traveller, trav)) {
                return trav;
            }
            if (!PortbiletParseTravellersProcessor.sameName(traveller, trav) || (sameBirthday = PortbiletParseTravellersProcessor.sameBirthday(traveller, trav)) != null && !sameBirthday.booleanValue()) continue;
            return trav;
        }
        return null;
    }

    private static boolean samePassport(Traveller t1, Traveller t2) {
        if (t1.getPassport() != null && t2.getPassport() != null && !TextUtil.isBlank((String)t1.getPassport().getNumber()) && !TextUtil.isBlank((String)t2.getPassport().getNumber())) {
            return t1.getPassport().getNumber().replaceAll(PASSPORT_REGEX, "").equalsIgnoreCase(t2.getPassport().getNumber().replaceAll(PASSPORT_REGEX, ""));
        }
        return false;
    }

    private static boolean sameName(Traveller t1, Traveller t2) {
        return TextUtil.isSame((String)t1.getName(), (String)t2.getName(), (boolean)true);
    }

    private static Boolean sameBirthday(Traveller t1, Traveller t2) {
        if (t1.getBirthday() != null && t2.getBirthday() != null) {
            return t1.getBirthday().compareTo(t2.getBirthday()) == 0;
        }
        return null;
    }

    private <T> void set(Consumer<T> setter, Supplier<T> getter) {
        if (getter.get() != null) {
            setter.accept(getter.get());
        }
    }

    private void setName(Consumer<String> setter, Supplier<String> toTravellerGetter, Supplier<String> fromTravellerGetter) {
        if (TextUtil.isBlank((String)toTravellerGetter.get())) {
            setter.accept(fromTravellerGetter.get());
        } else if (TextUtil.nonBlank((String)fromTravellerGetter.get()) && toTravellerGetter.get().length() < fromTravellerGetter.get().length()) {
            setter.accept(fromTravellerGetter.get());
        }
    }
}

