/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class PortbiletUpdateBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Map agents = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.AGENTS);
        Map products = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCTS);
        Set newProductUids = (Set)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.NEW_PRODUCT_UIDS);
        Set unchangedProductUids = (Set)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.UNCHANGED_PRODUCT_UIDS);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.TRAVELLERS);
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        BookingHelper.copyCustomer((Customer)bookingFile.getCustomer(), (Customer)orderItem.getCustomer());
        bookingFile.setCreateDate(orderItem.getBookingFile().getCreateDate());
        AtomicBoolean bookingFileChanged = new AtomicBoolean(false);
        orderItem.getReservations().forEach(wrapper -> {
            Reservation reservation;
            Reservation wrapperReservation = wrapper.getReservation();
            Optional<Reservation> optionalReservation = bookingFile.getReservations().stream().filter(res -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)wrapperReservation, (GdsName)GdsName.PORTBILET, (RecordLocatorType)RecordLocatorType.DEFAULT), (GdsName)GdsName.PORTBILET)).findFirst();
            if (optionalReservation.isPresent()) {
                reservation = optionalReservation.get();
                reservation.setPricingDate(wrapperReservation.getPricingDate());
                reservation.setResDate(wrapperReservation.getResDate());
                reservation.setTimeLimit(wrapperReservation.getTimeLimit());
            } else {
                reservation = wrapperReservation;
                BookingHelper.addReservation((BookingFile)bookingFile, (Reservation)reservation);
            }
            reservation.setType(ReservationType.OFFLINE);
            GdsReferenceIndex agent = (GdsReferenceIndex)((MiscUtil.Pair)agents.get(wrapper)).getSecond();
            if (agent != null) {
                bookingFile.setAgency(agent.getAgency());
                reservation.setBookingAgent(agent.getSource());
                reservation.setSalesPoint(agent.getSalesPoint());
            }
            bookingFile.getTravellers().clear();
            bookingFile.getTravellers().addAll(travellers.values().stream().collect(Collectors.toMap(BaseIdentity::getUid, t -> t, (t1, t2) -> t1)).values());
            for (String string : wrapper.getProductUids()) {
                if (!newProductUids.contains(string)) continue;
                BaseProduct product = (BaseProduct)products.get(string);
                product.setReservation(reservation);
                reservation.getProducts().add(product);
                bookingFileChanged.set(true);
            }
            for (Map.Entry entry : products.entrySet()) {
                if (unchangedProductUids.contains(entry.getKey())) continue;
                bookingFileChanged.set(true);
                ProductHandler.of((BaseProduct)((BaseProduct)entry.getValue())).setContractRulesApplied((BaseProduct)entry.getValue(), false);
            }
        });
        ctx.putObject((Enum)IBusParsersContextKeys.BOOKING_FILE_CHANGED, (Object)bookingFileChanged.get());
    }
}

