/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process.air;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.PortbiletHelper;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PortbiletCreateAirFopsDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Map.Entry productEntry = (Map.Entry)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCT_ENTRY);
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Product product = (Product)productEntry.getValue();
        PortbiletOrderItem.ProductWrapper productWrapper = orderItem.getProducts().get(productEntry.getKey());
        this.createFopsData(product, productWrapper, orderItem, ctx);
    }

    private void createFopsData(Product product, PortbiletOrderItem.ProductWrapper productWrapper, PortbiletOrderItem orderItem, MessageContext ctx) {
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            Product exchangeProduct = product.getPreviousProduct();
            List exchangeVendorFops = AirProductHelper.getVendorFops((Product)exchangeProduct);
            List exchangeFopsData = exchangeVendorFops.stream().map(it -> {
                FopItem item = new FopItem();
                item.setPaymentType(it.getType());
                item.setAmount(it.getAmount().getValue());
                return item;
            }).collect(Collectors.toList());
            ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, exchangeFopsData);
        }
        FopItem fopItem = PortbiletHelper.createFopItem(orderItem, productWrapper, product.getAddCollectEquivalent() != null ? product.getAddCollectEquivalent() : AirProductHelper.getTotalEquivalentFare((Product)product));
        ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(fopItem));
    }
}

