/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process.air;

import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.HashMap;

public class PortbiletParseAirSegmentTariffProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        HashMap<String, SegmentTariff> segmentTariffs = new HashMap<String, SegmentTariff>();
        for (PortbiletOrderItem.SegmentTariffWrapper segmentTariffWrapper : orderItem.getSegmentTariffWrapper()) {
            SegmentTariff segmentTariff = new SegmentTariff();
            for (String segmentUid : segmentTariffWrapper.getSegmentUids()) {
                PortbiletOrderItem.SegmentWrapper segmentWrapper = orderItem.getSegments().get(segmentUid);
                Segment segment = segmentWrapper.getSegment();
                segment.setDepartureLocation(orderItem.getGeoLocations().get(segmentWrapper.getDepartureLocationUid()));
                segment.setArriveLocation(orderItem.getGeoLocations().get(segmentWrapper.getArriveLocationUid()));
                segment.setAirline(orderItem.getAirlines().get(segmentWrapper.getAirlineUid()));
                segment.setBoard(orderItem.getBoards().get(segmentWrapper.getAircraftUid()));
                segment.setCodeShareCarrier(orderItem.getAirlines().get(segmentWrapper.getCodeShareCarrierUid()));
                PortbiletOrderItem.AirLuggageInfoWrapper luggageInfoWrapper = orderItem.getLuggageInfos().get(segmentWrapper.getLuggageInfoUid());
                if (luggageInfoWrapper != null) {
                    LuggageInfo luggageInfo = luggageInfoWrapper.getLuggageInfo();
                    luggageInfo.setUnit(orderItem.getLuggageUnits().get(luggageInfoWrapper.getLuggageUnitUid()));
                    segment.setLuggageInfo(luggageInfo);
                }
                segmentTariff.getSegments().add(segment);
            }
            segmentTariffs.put(segmentTariffWrapper.getUid(), segmentTariff);
        }
        ctx.putObject((Enum)IbusPortbiletParserContextKeys.SEGMENT_TARIFFS, segmentTariffs);
    }
}

