/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process.air;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.PortbiletHelper;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.HashMap;
import java.util.Map;

public class PortbiletUpdateAirProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Map agents = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.AGENTS);
        Map segmentTariffs = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.SEGMENT_TARIFFS);
        Map travellers = (Map)ctx.getObject((Enum)IbusPortbiletParserContextKeys.TRAVELLERS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCTS);
        Map.Entry productEntry = (Map.Entry)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCT_ENTRY);
        Map oldProducts = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.OLD_PRODUCTS);
        Product product = (Product)productEntry.getValue();
        oldProducts.put(productEntry.getKey(), (Product)product.clone(false, new HashMap()));
        PortbiletOrderItem.ProductWrapper productWrapper = orderItem.getProducts().get(productEntry.getKey());
        MiscUtil.Pair pair = (MiscUtil.Pair)agents.get(agents.keySet().stream().filter(r -> r.getProductUids().contains(productEntry.getKey())).findFirst().orElse(null));
        this.updateProduct(ctx, product, productWrapper, orderItem, (EntityReference<Person>)((EntityReference)pair.getFirst()), (GdsReferenceIndex)pair.getSecond(), segmentTariffs, travellers, productMap);
    }

    private void updateProduct(MessageContext ctx, Product product, PortbiletOrderItem.ProductWrapper productWrapper, PortbiletOrderItem orderItem, EntityReference<Person> agentRef, GdsReferenceIndex agent, Map<String, SegmentTariff> segmentTariffs, Map<String, Traveller> travellers, Map<String, Product> productMap) {
        BlankType type;
        product.setSystemNumber(productWrapper.getSystemNumber());
        product.setStatus(productWrapper.getStatus());
        product.setProductCategory(productWrapper.getProductCategory());
        product.setMcoCategory((MCOCategory)EnumUtil.fromNameSafe(MCOCategory.class, (String)productWrapper.getMcoCategory(), (boolean)true));
        product.setTicketType(productWrapper.getTicketType());
        product.setTariffType(productWrapper.getTariffType());
        product.setIssueDate(productWrapper.getIssueDate());
        product.setBlankOwnerRef(orderItem.getOrganizations().get(productWrapper.getBlankOwnerRefUid()));
        product.setBlankOwnerNumber(productWrapper.getBlankOwnerNumber());
        product.setBlankType(PortbiletHelper.getBlankType(orderItem, productWrapper, ctx));
        if (product.getBlankType() != null && product.getBlankOwnerRef() == null && (type = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType())) != null && type.getBlankOwner() != null) {
            product.setBlankOwnerRef(type.getBlankOwner());
            EntityContainer blankOwner = EntityStorage.get().resolve(type.getBlankOwner());
            if (blankOwner != null) {
                Airline airline = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(((Organization)blankOwner.getEntity()).getAirline());
                product.setBlankOwnerNumber(airline == null ? null : airline.getAirlineNumber());
            }
        }
        product.setCarrier(orderItem.getAirlines().get(productWrapper.getCarrierUid()));
        product.setCarrierNumber(productWrapper.getCarrierNumber());
        product.setCashier(agentRef);
        if (agent != null && agent.getAgency() != null) {
            AirProductHelper.setAgency((Product)product, (EntityReference)agent.getAgency());
        }
        product.setSalesPoint(agent != null ? agent.getSalesPoint() : null);
        product.setGdsCurrency(productWrapper.getGdsCurrency());
        product.setValidatorCode(productWrapper.getValidatorCode());
        product.setValidatorRef(PortbiletHelper.getValidatorRef((BaseProduct)product));
        Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)product.getValidatorRef());
        if (validator != null) {
            AirProductHelper.setSupplier((Product)product, (EntityReference)validator.getSupplier());
        } else {
            AirProductHelper.setSupplier((Product)product, PortbiletHelper.findSupplier());
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_supplierDefineFailedFromValidator, (Object[])new Object[]{product.getValidatorCode()}));
        }
        product.setPcc(productWrapper.getPcc());
        product.setConjCount(productWrapper.getConjCount());
        product.setAddCollectBase(productWrapper.getAddCollectBase());
        product.setAddCollectEquivalent(productWrapper.getAddCollectEquivalent());
        product.setPenalty(productWrapper.getPenalty());
        product.setTotalVendorEquivalentVatAmount(productWrapper.getTotalVendorEquivalentVatAmount());
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, travellers.get(productWrapper.getTravellerUid()));
        product.setPassengerType(PortbiletHelper.getPassengerType(orderItem, productWrapper.getPassengerTypeUid()));
        product.setVendorVatDetalization(PortbiletHelper.getVendorVatDetalization(orderItem, productWrapper));
        product.setEndorsement(productWrapper.getEndorsement());
        product.setFareCalculationData(productWrapper.getFareCalculationData());
        AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
        vendorContractRelation.getCommissions().clear();
        PortbiletHelper.getSubagentCommissions(orderItem, productWrapper).stream().map(AirProductHelper::fromGeneralProductCommission).forEach(commission -> vendorContractRelation.getCommissions().add(commission));
        product.getFares().clear();
        for (String uid : productWrapper.getFareUids()) {
            PortbiletOrderItem.ProductFareWrapper productFareWrapper = orderItem.getProductFares().get(uid);
            ProductFare productFare = productFareWrapper.getProductFare();
            productFare.setSegmentTariff(segmentTariffs.get(productFareWrapper.getSegmentTariffUid()));
            productFare.setBaseFare(orderItem.getMoney().get(productFareWrapper.getAmountUid()));
            product.getFares().add(productFare);
        }
        product.getSegmentTariffs().clear();
        for (String segmentTariffUid : productWrapper.getSegmentTariffUids()) {
            product.getSegmentTariffs().add(segmentTariffs.get(segmentTariffUid));
        }
        product.getTaxes().clear();
        for (String taxUid : productWrapper.getTaxUids()) {
            PortbiletOrderItem.AirTaxWrapper taxWrapper = orderItem.getAirTaxes().get(taxUid);
            Tax tax = taxWrapper.getTax();
            tax.setAmount(orderItem.getMoney().get(taxWrapper.getAmountUid()));
            tax.setSegmentTariff(segmentTariffs.get(taxWrapper.getSegmentTariffUid()));
            product.getTaxes().add(tax);
        }
        product.getRelatedProducts().clear();
        for (String relatedProductUid : productWrapper.getRelatedProductUids()) {
            product.getRelatedProducts().add(productMap.get(relatedProductUid));
        }
    }
}

