/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process.hotel;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.PortbiletHelper;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PortbiletUpdateHotelProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Map agents = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.AGENTS);
        Map travellers = (Map)ctx.getObject((Enum)IbusPortbiletParserContextKeys.TRAVELLERS);
        Map products = (Map)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PRODUCTS);
        Map.Entry productEntry = (Map.Entry)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCT_ENTRY);
        Map oldProducts = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.OLD_PRODUCTS);
        HotelProduct product = (HotelProduct)productEntry.getValue();
        oldProducts.put(productEntry.getKey(), (HotelProduct)product.clone(false, new HashMap()));
        PortbiletOrderItem.ProductWrapper productWrapper = orderItem.getProducts().get(productEntry.getKey());
        MiscUtil.Pair pair = (MiscUtil.Pair)agents.get(agents.keySet().stream().filter(r -> r.getProductUids().contains(productEntry.getKey())).findFirst().orElse(null));
        this.updateProduct(ctx, product, productWrapper, orderItem, (EntityReference<Person>)((EntityReference)pair.getFirst()), (GdsReferenceIndex)pair.getSecond(), products, travellers);
    }

    private void updateProduct(MessageContext ctx, HotelProduct product, PortbiletOrderItem.ProductWrapper productWrapper, PortbiletOrderItem orderItem, EntityReference<Person> agentRef, GdsReferenceIndex agent, Map<String, BaseProduct> products, Map<String, Traveller> travellers) {
        product.setSystemNumber(productWrapper.getSystemNumber());
        product.setStatus(productWrapper.getStatus());
        product.setTicketType(productWrapper.getTicketType());
        product.setIssueDate(productWrapper.getIssueDate());
        product.setProvider(productWrapper.getHotelProvider());
        EntityReference<Organization> blankOwnerRef = orderItem.getOrganizations().get(productWrapper.getBlankOwnerRefUid());
        if (blankOwnerRef != null) {
            product.setBlankOwnerRef(blankOwnerRef);
        } else {
            product.setBlankOwnerRef(this.findBlankOwner(productWrapper.getBlankOwnerCode()));
        }
        product.setCashier(agentRef);
        if (agent != null && agent.getAgency() != null) {
            HotelProductHelper.setAgency((HotelProduct)product, (EntityReference)agent.getAgency());
        }
        product.setSalesPoint(agent != null ? agent.getSalesPoint() : null);
        product.setGdsCurrency(productWrapper.getGdsCurrency());
        product.setValidatorCode(productWrapper.getValidatorCode());
        Validator validator = (Validator)EntityStorageHelper.resolve(PortbiletHelper.getValidatorRef((BaseProduct)product));
        if (validator != null) {
            HotelProductHelper.setSupplier((HotelProduct)product, (EntityReference)validator.getSupplier());
        } else {
            HotelProductHelper.setSupplier((HotelProduct)product, PortbiletHelper.findSupplier());
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_supplierDefineFailedFromValidator, (Object[])new Object[]{product.getValidatorCode()}));
        }
        product.setPcc(productWrapper.getPcc());
        product.setVendorVatDetalization(PortbiletHelper.getVendorVatDetalization(orderItem, productWrapper));
        product.setHotelStars(productWrapper.getHotelStars());
        product.setHotelAddress(productWrapper.getHotelAddress());
        product.setHotelPhone(productWrapper.getHotelPhone());
        product.setHotelFax(productWrapper.getHotelFax());
        product.setFreeCancellationTerm(productWrapper.getFreeCancellationTerm());
        product.setCancellable(productWrapper.isCancellable());
        product.setCancellableNow(productWrapper.getCancellableNow());
        product.setHotelCountry(orderItem.getCountries().get(productWrapper.getHotelCountryUid()));
        product.setHotelLocation(orderItem.getGeoLocations().get(productWrapper.getHotelLocationUid()));
        product.setHotelName(productWrapper.getHotelName());
        product.setProvider(productWrapper.getHotelProvider());
        product.setCotsGuaranteed(productWrapper.isCotsGuaranteed());
        product.setWaitingForRefundConfirmation(productWrapper.isWaitingForRefundConfirmation());
        HotelProductContractRelationData vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)product);
        if (vendorContractRelation != null) {
            vendorContractRelation.getCommissions().clear();
            Iterator<String> commissionWrapper = orderItem.getHotelCommissions().get(productWrapper.getHotelCommissionUid());
            HotelProductCommission hotelCommission = ((PortbiletOrderItem.HotelCommissionWrapper)((Object)commissionWrapper)).getCommission();
            if (hotelCommission != null) {
                hotelCommission.setAmount(orderItem.getMoney().get(((PortbiletOrderItem.HotelCommissionWrapper)((Object)commissionWrapper)).getAmountUid()));
                product.setHotelAggrCommission(hotelCommission);
                vendorContractRelation.getCommissions().add(HotelsHelper.toHotelGeneralProductCommission((HotelProductCommission)hotelCommission));
            }
            vendorContractRelation.getCommissions().addAll(PortbiletHelper.getSubagentCommissions(orderItem, productWrapper));
        }
        product.getRooms().clear();
        for (String roomUid : productWrapper.getRoomUids()) {
            PortbiletOrderItem.HotelRoomWrapper hotelRoomWrapper = orderItem.getHotelRooms().get(roomUid);
            Room room = hotelRoomWrapper.getRoom();
            room.setBaseRate(orderItem.getMoney().get(hotelRoomWrapper.getBaseRateUid()));
            room.setBasePrice(orderItem.getMoney().get(hotelRoomWrapper.getBasePriceUid()));
            room.setMeal(orderItem.getHotelMeals().get(hotelRoomWrapper.getMealUid()));
            room.setAvailability(orderItem.getHotelsAvailabilities().get(hotelRoomWrapper.getAvailabilityUid()));
            for (String roomTravellerUid : hotelRoomWrapper.getRoomTravellerUids()) {
                room.getRoomTravellersUids().add(travellers.get(roomTravellerUid).getUid());
            }
            product.getRooms().add(room);
        }
        product.getAdditionalServices().clear();
        for (String additionalServiceUid : productWrapper.getAdditionalServiceUids()) {
            PortbiletOrderItem.AdditionalServiceWrapper additionalServiceWrapper = orderItem.getAdditionalServices().get(additionalServiceUid);
            AdditionalService additionalService = additionalServiceWrapper.getAdditionalService();
            additionalService.setBaseAmount(orderItem.getMoney().get(additionalServiceWrapper.getBaseAmountUid()));
            product.getAdditionalServices().add(additionalService);
        }
        product.getTaxes().clear();
        for (String taxUid : productWrapper.getTaxUids()) {
            PortbiletOrderItem.HotelTaxWrapper taxWrapper = orderItem.getHotelTaxes().get(taxUid);
            HotelProductTax tax = taxWrapper.getTax();
            product.getTaxes().add(tax);
        }
        product.getCancellationCharges().clear();
        for (String cancellationChargeUid : productWrapper.getCancellationChargeUids()) {
            PortbiletOrderItem.CancellationChargeWrapper cancellationChargeWrapper = orderItem.getCancellationCharges().get(cancellationChargeUid);
            CancellationCharge cancellationCharge = cancellationChargeWrapper.getCancellationCharge();
            PortbiletOrderItem.RateMoneyWrapper rateMoneyWrapper = orderItem.getRateMoney().get(cancellationChargeWrapper.getPenaltyUid());
            RateMoney rateMoney = rateMoneyWrapper.getRateMoney();
            rateMoney.setMoney(orderItem.getMoney().get(rateMoneyWrapper.getMoneyUid()));
            cancellationCharge.setPenalty(rateMoney);
            product.getCancellationCharges().add(cancellationCharge);
        }
        List vendorFops = HotelProductHelper.getVendorFops((HotelProduct)product);
        vendorFops.clear();
        vendorFops.add(this.getVendorFop(orderItem, productWrapper, product));
        product.getTravellers().clear();
        for (String travellerUid : productWrapper.getTravellerUids()) {
            product.getTravellers().add(travellers.get(travellerUid));
        }
        product.getTravellersPassengerTypes().clear();
        for (String travellersPassengerTypeUid : productWrapper.getTravellersPassengerTypeUids()) {
            PortbiletOrderItem.PassengerTypeReferenceWrapper passengerTypeReferenceWrapper = orderItem.getPassengerTypeReferences().get(travellersPassengerTypeUid);
            PassengerTypeReference passengerTypeReference = new PassengerTypeReference();
            passengerTypeReference.setTravellerUid(travellers.get(passengerTypeReferenceWrapper.getTravellerUid()).getUid());
            passengerTypeReference.setPassengerType(PortbiletHelper.getPassengerType(orderItem, passengerTypeReferenceWrapper.getPassengerTypeUid()));
            product.getTravellersPassengerTypes().add(passengerTypeReference);
        }
    }

    private EntityReference<Organization> findBlankOwner(String code) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
        List organizationIndices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (organizationIndices.size() == 1) {
            return ((OrganizationIndex)organizationIndices.get(0)).getSource();
        }
        return null;
    }

    private HotelProductFop getVendorFop(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper, HotelProduct product) {
        HotelProductFop fop = new HotelProductFop();
        FopItem fopItem = PortbiletHelper.createFopItem(orderItem, productWrapper, HotelProductHelper.calculateTotalEquivalentFare((HotelProduct)product));
        fop.setType(fopItem.getPaymentType());
        fop.setAmount(MoneyHelper.buildMoney((BigDecimal)fopItem.getAmount(), (String)product.getGdsCurrency()));
        return fop;
    }
}

