/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.process.railway;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.IbusPortbiletParserContextKeys;
import com.gridnine.xtrip.server.parsers.portbilet.ibus.PortbiletHelper;
import com.gridnine.xtrip.server.parsers.portbilet.model.order.PortbiletOrderItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortbiletUpdateRailwayMcoProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PortbiletOrderItem orderItem = (PortbiletOrderItem)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PORTBILET_ORDER_ITEM);
        Map agents = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.AGENTS);
        Map travellers = (Map)ctx.getObject((Enum)IbusPortbiletParserContextKeys.TRAVELLERS);
        Map products = (Map)ctx.getObject((Enum)IbusPortbiletParserContextKeys.PRODUCTS);
        Map.Entry productEntry = (Map.Entry)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.PRODUCT_ENTRY);
        Map oldProducts = (Map)ctx.getMandatoryObject((Enum)IbusPortbiletParserContextKeys.OLD_PRODUCTS);
        RailwayMcoProduct product = (RailwayMcoProduct)productEntry.getValue();
        oldProducts.put(productEntry.getKey(), (RailwayMcoProduct)product.clone(false, new HashMap()));
        PortbiletOrderItem.ProductWrapper productWrapper = orderItem.getProducts().get(productEntry.getKey());
        MiscUtil.Pair pair = (MiscUtil.Pair)agents.get(agents.keySet().stream().filter(r -> r.getProductUids().contains(productEntry.getKey())).findFirst().orElse(null));
        this.updateProduct(ctx, product, productWrapper, orderItem, (EntityReference<Person>)((EntityReference)pair.getFirst()), (GdsReferenceIndex)pair.getSecond(), products, travellers);
    }

    private void updateProduct(MessageContext ctx, RailwayMcoProduct product, PortbiletOrderItem.ProductWrapper productWrapper, PortbiletOrderItem orderItem, EntityReference<Person> agentRef, GdsReferenceIndex agent, Map<String, BaseProduct> products, Map<String, Traveller> travellers) {
        BlankType type;
        product.setSystemNumber(productWrapper.getSystemNumber());
        product.setStatus(productWrapper.getStatus());
        product.setMcoCategory((RailwayMcoCategory)EnumUtil.fromNameSafe(RailwayMcoCategory.class, (String)productWrapper.getMcoCategory(), (boolean)true));
        product.setTicketType(productWrapper.getTicketType());
        product.setIssueDate(productWrapper.getIssueDate());
        product.setBlankOwnerRef(orderItem.getOrganizations().get(productWrapper.getBlankOwnerRefUid()));
        product.setBlankType(PortbiletHelper.getBlankType(orderItem, productWrapper, ctx));
        if (product.getBlankType() != null && product.getBlankOwnerRef() == null && (type = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType())) != null && type.getBlankOwner() != null) {
            product.setBlankOwnerRef(type.getBlankOwner());
        }
        product.setCarrierNumber(productWrapper.getCarrierNumber());
        product.setCashier(agentRef);
        if (agent != null && agent.getAgency() != null) {
            RailwayMcoProductHelper.setAgency((RailwayMcoProduct)product, (EntityReference)agent.getAgency());
        }
        product.setSalesPoint(agent != null ? agent.getSalesPoint() : null);
        product.setGdsCurrency(productWrapper.getGdsCurrency());
        product.setValidatorCode(productWrapper.getValidatorCode());
        product.setValidatorRef(PortbiletHelper.getValidatorRef((BaseProduct)product));
        Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)product.getValidatorRef());
        if (validator != null) {
            RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)validator.getSupplier());
        } else {
            RailwayProductHelper.setSupplier((BaseTicketProduct)product, PortbiletHelper.findSupplier());
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ParsersHelper_supplierDefineFailedFromValidator, (Object[])new Object[]{product.getValidatorCode()}));
        }
        product.setProvider(orderItem.getOrganizations().get(productWrapper.getProviderUid()));
        product.setProviderSystemNumber(productWrapper.getProviderSystemNumber());
        product.setPcc(productWrapper.getPcc());
        product.setEquivalentFare(productWrapper.getEquivalentFare());
        product.setEquivalentVat(productWrapper.getEquivalentVat());
        product.setPenaltyFare(productWrapper.getPenaltyare());
        product.setPenaltyVat(productWrapper.getPenaltyVat());
        GeneralProductContractRelationData vendorContractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
        vendorContractRelation.getCommissions().addAll(PortbiletHelper.getSubagentCommissions(orderItem, productWrapper));
        Map<String, RailwaySegment> segments = PortbiletHelper.getRailwaySegments(orderItem, productWrapper);
        product.getSegments().clear();
        product.getSegments().addAll(segments.values());
        List vendorFops = RailwayMcoProductHelper.getVendorFops((RailwayMcoProduct)product);
        vendorFops.clear();
        vendorFops.add(this.getVendorFop(orderItem, productWrapper, product));
        product.getPassengers().clear();
        for (String passengerUid : productWrapper.getPassengerUids()) {
            product.getPassengers().add(travellers.get(passengerUid));
        }
        product.getRelatedProducts().clear();
        for (String relatedProductUid : productWrapper.getRelatedProductUids()) {
            product.getRelatedProducts().add((RailwayProduct)products.get(relatedProductUid));
        }
    }

    private GeneralProductFop getVendorFop(PortbiletOrderItem orderItem, PortbiletOrderItem.ProductWrapper productWrapper, RailwayMcoProduct product) {
        GeneralProductFop fop = new GeneralProductFop();
        FopItem fopItem = PortbiletHelper.createFopItem(orderItem, productWrapper, RailwayMcoProductHelper.calculateTotalEquivalentFare((RailwayMcoProduct)product));
        fop.setType(fopItem.getPaymentType());
        fop.setEquivalentAmount(fopItem.getAmount());
        return fop;
    }
}

