/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.portbilet.ibus.registration;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.portbilet.model.PortbiletExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PortbiletParserRegisterExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        byte[] file = (byte[])ctx.getObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        if (file == null) {
            return;
        }
        PortbiletExchangeDocument portbiletExchangeDocument = new PortbiletExchangeDocument();
        portbiletExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
        portbiletExchangeDocument.setContentType(ContentType.XML);
        portbiletExchangeDocument.setContent(file);
        String stringDocumentContent = new String(file, StandardCharsets.UTF_8);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(stringDocumentContent)));
        document.getDocumentElement().normalize();
        Element root = document.getDocumentElement();
        NodeList bookingFilesNode = root.getElementsByTagName("bookingFiles");
        Element bookingFiles = (Element)bookingFilesNode.item(0);
        String date = ((Element)bookingFiles.getElementsByTagName("bookingFile").item(0)).getElementsByTagName("createDate").item(0).getTextContent();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        portbiletExchangeDocument.setIssueDate(dateFormat.parse(date));
        NodeList entityNodeList = ((Element)((Object)root.getElementsByTagName("entities").item(0).getChildNodes())).getElementsByTagName("entity");
        block16: for (int i = 0; i < entityNodeList.getLength(); ++i) {
            String status;
            String type = ((Element)entityNodeList.item(i)).getAttribute("type");
            if (type.equals("com.gridnine.xtrip.common.model.booking.Reservation")) {
                portbiletExchangeDocument.getPnrLocator().add(((Element)entityNodeList.item(i)).getElementsByTagName("recordLocator").item(0).getTextContent());
            }
            if (type.equals("com.gridnine.xtrip.common.model.booking.Traveller")) {
                portbiletExchangeDocument.getTravellers().add(((Element)entityNodeList.item(i)).getElementsByTagName("name").item(0).getTextContent());
            }
            if (!type.equals("com.gridnine.xtrip.common.model.booking.air.Product") && !type.equals("com.gridnine.xtrip.common.model.booking.railway.RailwayProduct") && !type.equals("com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct")) continue;
            Node systemNumberNode = ((Element)entityNodeList.item(i)).getElementsByTagName("systemNumber").item(0);
            if (systemNumberNode != null) {
                portbiletExchangeDocument.getTicketNumbers().add(systemNumberNode.getTextContent());
            }
            switch (status = ((Element)entityNodeList.item(i)).getElementsByTagName("status").item(0).getTextContent()) {
                case "BOOKING": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.BOOKING);
                    continue block16;
                }
                case "SELL": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.SELL);
                    continue block16;
                }
                case "REFUND": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.REFUND);
                    continue block16;
                }
                case "VOID": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.CANCEL);
                    continue block16;
                }
                case "VOID_BOOKING": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.CANCEL_BOOKING);
                    continue block16;
                }
                case "EXCHANGE": {
                    portbiletExchangeDocument.getTransactionTypes().add(TransactionType.EXCHANGE);
                }
            }
        }
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST, Collections.singletonList(portbiletExchangeDocument));
    }
}

