/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.s7ndc.ibus.registration;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.s7ndc.S7ndcExchangeDocument;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class S7ndcHandleRegisterExchangeDocumentAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (ExceptionUtil.isInterruptedError((Throwable)e)) {
            this.log.warn("interrupted exception occurred", e);
            ctx.putObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED, (Object)Boolean.TRUE);
        }
        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438", (Throwable)e, (Object[])new Object[]{e.getMessage()}));
        return true;
    }

    public void after(MessageContext ctx) throws Exception {
        Collection messages = ctx.getMessagesReadOnly();
        Boolean interruptedExceptionOccurred = (Boolean)ctx.getObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED);
        if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR)) {
            ExchangeFile file = (ExchangeFile)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
            String checkSum = (String)ctx.getObject((Enum)IBusParsersContextKeys.CHECK_SUM);
            if (checkSum == null) {
                checkSum = MiscUtil.getCheckSum((byte[])file.getContent());
            }
            S7ndcExchangeDocument exchangeDocument = new S7ndcExchangeDocument();
            exchangeDocument.setContentType(ContentType.XML);
            exchangeDocument.setContent(new String(file.getContent(), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
            exchangeDocument.setLocation(file.getLocation());
            exchangeDocument.setCreated(file.getCreated());
            exchangeDocument.setType(file.getType());
            exchangeDocument.setCheckSum(checkSum);
            exchangeDocument.setStatus(Boolean.TRUE.equals(interruptedExceptionOccurred) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
            exchangeDocument.getMessages().clear();
            exchangeDocument.getMessages().addAll(messages);
            EntityStorage.get().save(EntityContainer.create((BaseEntity)exchangeDocument), true);
        }
    }
}

