/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.yandexTaxi.ibus.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.IBusYandexTaxiParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.util.Objects;

public class YandexTaxiParserCreateFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        YandexTaxiExchangeDocument document = (YandexTaxiExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        TaxiProduct product = (TaxiProduct)ctx.getMandatoryObject((Enum)IBusYandexTaxiParserContextKeys.PRODUCT);
        for (GeneralProductContractRelationData relation : TaxiHelper.getContractRelations((TaxiProduct)product)) {
            GeneralProductFop fopToAdd = new GeneralProductFop();
            fopToAdd.setType(PaymentType.INVOICE);
            if (product.getEquivalentFare() != null) {
                fopToAdd.setEquivalentAmount(product.getEquivalentFare().getValue());
            }
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            switch (contractType) {
                case SUBAGENCY: {
                    if (!this.hasSubagency(product)) break;
                }
                case VENDOR: 
                case CLIENT: {
                    if (relation.getFops().stream().anyMatch(fop -> Objects.equals(fop.getEquivalentAmount(), fopToAdd.getEquivalentAmount()))) break;
                    if (contractType == ContractType.SUBAGENCY && ShipmentHelper.hasSubagentRelatedShipment((BaseProduct)product)) {
                        document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0438\u0435 \u0424\u041e\u041f.", (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)product)}));
                        break;
                    }
                    if (contractType == ContractType.CLIENT && ShipmentHelper.hasClientRelatedShipment((BaseProduct)product)) {
                        document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0435 \u0424\u041e\u041f.", (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)product)}));
                        break;
                    }
                    relation.getFops().clear();
                    relation.getFops().add(fopToAdd);
                }
            }
        }
    }

    private boolean hasSubagency(TaxiProduct product) {
        EntityReference agency = TaxiHelper.getAgency((TaxiProduct)product);
        EntityReference subagency = TaxiHelper.getSubagency((TaxiProduct)product);
        return agency != null && subagency != null && !agency.equals((Object)subagency);
    }
}

