/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.yandexTaxi.ibus.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.IBusYandexTaxiParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.yandexTaxi.YandexTaxiProductData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.yandexTaxi.YandexTaxiParserHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.BooleanUtils;

public class YandexTaxiParserFindAgentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        YandexTaxiExchangeDocument document = (YandexTaxiExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        final YandexTaxiProductData data = document.getProduct();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.phones.name(), (Object)YandexTaxiParserHelper.wrap(data.getAgentPhoneNumber())), SearchCriterion.contains((String)PersonIndex.Property.emails.name(), (Object)YandexTaxiParserHelper.wrap(data.getAgentEmail()))}));
        List persons = EntityStorage.get().search(PersonIndex.class, query).getData();
        persons.sort(new Comparator<PersonIndex>(){

            @Override
            public int compare(PersonIndex o1, PersonIndex o2) {
                return this.getScore(o1) - this.getScore(o2);
            }

            private int getScore(PersonIndex person) {
                return 2 * BooleanUtils.toInteger((boolean)person.getPhones().stream().anyMatch(phone -> phone.contains(Optional.ofNullable(data.getAgentPhoneNumber()).orElse(YandexTaxiParserHelper.NO_MATCH_STRING)))) + 2 * BooleanUtils.toInteger((boolean)person.getEmails().stream().anyMatch(email -> email.contains(Optional.ofNullable(data.getAgentEmail()).orElse(YandexTaxiParserHelper.NO_MATCH_STRING)))) + BooleanUtils.toInteger((boolean)TextUtil.isSame((String)person.getName(), (String)TextUtil.nonNullStr((String)data.getAgentName()).replaceAll("\t", " "), (boolean)true, (boolean)true));
            }
        }.reversed());
        if (persons.isEmpty()) {
            document.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u2116 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0430\u0433\u0435\u043d\u0442\u0430", (Object[])new Object[]{data.getProductNumber()}));
        } else {
            EntityReference agentRef = ((PersonIndex)persons.get(0)).getSource();
            ctx.putObject((Enum)IBusYandexTaxiParserContextKeys.AGENT, (Object)agentRef);
        }
    }
}

